/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.messaging;

import com.microsoft.azure.sdk.iot.service.messaging.FeedbackStatusCode;
import com.microsoft.azure.sdk.iot.service.messaging.serializers.FeedbackRecordParser;
import java.util.Date;

public class FeedbackRecord {
    private Date enqueuedTimeUtc;
    private String originalMessageId;
    private String correlationId = "";
    private FeedbackStatusCode statusCode;
    private String description;
    private String deviceGenerationId;
    private String deviceId;

    protected FeedbackRecord(FeedbackRecordParser parser) {
        this.description = parser.getDescription();
        this.deviceGenerationId = parser.getDeviceGenerationId();
        this.deviceId = parser.getDeviceId();
        this.enqueuedTimeUtc = parser.getEnqueuedTimeUtcDate();
        this.originalMessageId = parser.getOriginalMessageId();
        this.statusCode = parser.getStatusCode() == null ? FeedbackStatusCode.unknown : parser.getStatusCode();
    }

    public Date getEnqueuedTimeUtc() {
        return this.enqueuedTimeUtc;
    }

    void setEnqueuedTimeUtc(Date enqueuedTimeUtc) {
        this.enqueuedTimeUtc = enqueuedTimeUtc;
    }

    public String getOriginalMessageId() {
        return this.originalMessageId;
    }

    void setOriginalMessageId(String originalMessageId) {
        this.originalMessageId = originalMessageId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public FeedbackStatusCode getStatusCode() {
        return this.statusCode;
    }

    void setStatusCode(FeedbackStatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    public String getDeviceGenerationId() {
        return this.deviceGenerationId;
    }

    void setDeviceGenerationId(String deviceGenerationId) {
        this.deviceGenerationId = deviceGenerationId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }
}

