/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.messaging;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionStringBuilder;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.messaging.AcknowledgementType;
import com.microsoft.azure.sdk.iot.service.messaging.ErrorContext;
import com.microsoft.azure.sdk.iot.service.messaging.FeedbackBatch;
import com.microsoft.azure.sdk.iot.service.messaging.IotHubServiceClientProtocol;
import com.microsoft.azure.sdk.iot.service.messaging.MessageFeedbackProcessorClientOptions;
import com.microsoft.azure.sdk.iot.service.transport.amqps.EventReceivingConnectionHandler;
import com.microsoft.azure.sdk.iot.service.transport.amqps.ReactorRunner;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFeedbackProcessorClient {
    private static final Logger log = LoggerFactory.getLogger(MessageFeedbackProcessorClient.class);
    private static final int START_REACTOR_TIMEOUT_MILLISECONDS = 60000;
    private static final int STOP_REACTOR_TIMEOUT_MILLISECONDS = 5000;
    private final EventReceivingConnectionHandler eventReceivingConnectionHandler;
    private final Consumer<ErrorContext> errorProcessor;
    private ReactorRunner reactorRunner;
    private final String hostName;

    public MessageFeedbackProcessorClient(String hostName, TokenCredential credential, IotHubServiceClientProtocol protocol, Function<FeedbackBatch, AcknowledgementType> feedbackMessageProcessor) {
        this(hostName, credential, protocol, feedbackMessageProcessor, MessageFeedbackProcessorClientOptions.builder().build());
    }

    public MessageFeedbackProcessorClient(String hostName, TokenCredential credential, IotHubServiceClientProtocol protocol, Function<FeedbackBatch, AcknowledgementType> feedbackMessageProcessor, MessageFeedbackProcessorClientOptions options) {
        Objects.requireNonNull(options, "Options cannot be null");
        Objects.requireNonNull(feedbackMessageProcessor, "feedbackMessageProcessor cannot be null");
        this.errorProcessor = options.getErrorProcessor();
        this.hostName = hostName;
        this.eventReceivingConnectionHandler = new EventReceivingConnectionHandler(hostName, credential, protocol, null, feedbackMessageProcessor, this.errorProcessor, options.getProxyOptions(), options.getSslContext(), options.getKeepAliveInterval());
    }

    public MessageFeedbackProcessorClient(String hostName, AzureSasCredential azureSasCredential, IotHubServiceClientProtocol protocol, Function<FeedbackBatch, AcknowledgementType> feedbackMessageProcessor) {
        this(hostName, azureSasCredential, protocol, feedbackMessageProcessor, MessageFeedbackProcessorClientOptions.builder().build());
    }

    public MessageFeedbackProcessorClient(String hostName, AzureSasCredential azureSasCredential, IotHubServiceClientProtocol protocol, Function<FeedbackBatch, AcknowledgementType> feedbackMessageProcessor, MessageFeedbackProcessorClientOptions options) {
        Objects.requireNonNull(options, "Options cannot be null");
        Objects.requireNonNull(feedbackMessageProcessor, "feedbackMessageProcessor cannot be null");
        this.errorProcessor = options.getErrorProcessor();
        this.hostName = hostName;
        this.eventReceivingConnectionHandler = new EventReceivingConnectionHandler(hostName, azureSasCredential, protocol, null, feedbackMessageProcessor, this.errorProcessor, options.getProxyOptions(), options.getSslContext(), options.getKeepAliveInterval());
    }

    public MessageFeedbackProcessorClient(String connectionString, IotHubServiceClientProtocol protocol, Function<FeedbackBatch, AcknowledgementType> feedbackMessageProcessor) {
        this(connectionString, protocol, feedbackMessageProcessor, MessageFeedbackProcessorClientOptions.builder().build());
    }

    public MessageFeedbackProcessorClient(String connectionString, IotHubServiceClientProtocol protocol, Function<FeedbackBatch, AcknowledgementType> feedbackMessageProcessor, MessageFeedbackProcessorClientOptions options) {
        Objects.requireNonNull(options, "Options cannot be null");
        Objects.requireNonNull(feedbackMessageProcessor, "feedbackMessageProcessor cannot be null");
        if (connectionString == null || connectionString.isEmpty()) {
            throw new IllegalArgumentException("Connection string cannot be null or empty");
        }
        this.errorProcessor = options.getErrorProcessor();
        this.hostName = IotHubConnectionStringBuilder.createIotHubConnectionString(connectionString).getHostName();
        this.eventReceivingConnectionHandler = new EventReceivingConnectionHandler(connectionString, protocol, null, feedbackMessageProcessor, this.errorProcessor, options.getProxyOptions(), options.getSslContext(), options.getKeepAliveInterval());
    }

    public synchronized void start() throws IotHubException, IOException, InterruptedException, TimeoutException {
        this.start(60000);
    }

    public synchronized void start(int timeoutMilliseconds) throws IotHubException, IOException, InterruptedException, TimeoutException {
        if (this.isRunning()) {
            return;
        }
        if (timeoutMilliseconds < 0) {
            throw new IllegalArgumentException("timeoutMilliseconds must be greater than or equal to 0");
        }
        AtomicReference<Object> iotHubException = new AtomicReference<Object>(null);
        AtomicReference<Object> ioException = new AtomicReference<Object>(null);
        log.debug("Opening MessageFeedbackProcessorClient");
        this.reactorRunner = new ReactorRunner(this.hostName, "MessageFeedbackProcessor", this.eventReceivingConnectionHandler);
        CountDownLatch openLatch = new CountDownLatch(1);
        this.eventReceivingConnectionHandler.setOnConnectionOpenedCallback(openLatch::countDown);
        new Thread(() -> {
            try {
                this.reactorRunner.run();
                log.trace("MessageFeedbackProcessorClient Amqp reactor stopped, checking that the connection was opened");
                this.eventReceivingConnectionHandler.verifyConnectionWasOpened();
                log.trace("MessageFeedbackProcessorClient reactor did successfully open the connection, returning without exception");
            }
            catch (IOException e) {
                ioException.set(e);
            }
            catch (IotHubException e) {
                iotHubException.set(e);
            }
            finally {
                openLatch.countDown();
            }
        }).start();
        if (timeoutMilliseconds == 0) {
            openLatch.await();
        } else {
            boolean timedOut;
            boolean bl = timedOut = !openLatch.await(timeoutMilliseconds, TimeUnit.MILLISECONDS);
            if (timedOut) {
                throw new TimeoutException("Timed out waiting for the connection to the service to open");
            }
        }
        if (ioException.get() != null) {
            throw (IOException)ioException.get();
        }
        if (iotHubException.get() != null) {
            throw (IotHubException)iotHubException.get();
        }
        log.info("Started MessageFeedbackProcessorClient");
    }

    public synchronized void stop() throws InterruptedException {
        this.stop(5000);
    }

    public synchronized void stop(int timeoutMilliseconds) throws InterruptedException {
        if (this.reactorRunner == null) {
            return;
        }
        log.debug("Closing MessageFeedbackProcessorClient");
        this.reactorRunner.stop(timeoutMilliseconds);
        this.reactorRunner = null;
        log.info("Stopped MessageFeedbackProcessorClient");
    }

    public synchronized boolean isRunning() {
        return this.reactorRunner != null && this.reactorRunner.isRunning();
    }
}

