/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.messaging;

import com.microsoft.azure.sdk.iot.service.ProxyOptions;
import com.microsoft.azure.sdk.iot.service.messaging.ErrorContext;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;

public final class MessagingClientOptions {
    private final ProxyOptions proxyOptions;
    private final SSLContext sslContext;
    private final Consumer<ErrorContext> errorProcessor;
    private final int keepAliveInterval;

    private static int $default$keepAliveInterval() {
        return 230;
    }

    MessagingClientOptions(ProxyOptions proxyOptions, SSLContext sslContext, Consumer<ErrorContext> errorProcessor, int keepAliveInterval) {
        this.proxyOptions = proxyOptions;
        this.sslContext = sslContext;
        this.errorProcessor = errorProcessor;
        this.keepAliveInterval = keepAliveInterval;
    }

    public static MessagingClientOptionsBuilder builder() {
        return new MessagingClientOptionsBuilder();
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public Consumer<ErrorContext> getErrorProcessor() {
        return this.errorProcessor;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public static class MessagingClientOptionsBuilder {
        private ProxyOptions proxyOptions;
        private SSLContext sslContext;
        private Consumer<ErrorContext> errorProcessor;
        private boolean keepAliveInterval$set;
        private int keepAliveInterval$value;

        MessagingClientOptionsBuilder() {
        }

        public MessagingClientOptionsBuilder proxyOptions(ProxyOptions proxyOptions) {
            this.proxyOptions = proxyOptions;
            return this;
        }

        public MessagingClientOptionsBuilder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public MessagingClientOptionsBuilder errorProcessor(Consumer<ErrorContext> errorProcessor) {
            this.errorProcessor = errorProcessor;
            return this;
        }

        public MessagingClientOptionsBuilder keepAliveInterval(int keepAliveInterval) {
            this.keepAliveInterval$value = keepAliveInterval;
            this.keepAliveInterval$set = true;
            return this;
        }

        public MessagingClientOptions build() {
            int keepAliveInterval$value = this.keepAliveInterval$value;
            if (!this.keepAliveInterval$set) {
                keepAliveInterval$value = MessagingClientOptions.$default$keepAliveInterval();
            }
            return new MessagingClientOptions(this.proxyOptions, this.sslContext, this.errorProcessor, keepAliveInterval$value);
        }

        public String toString() {
            return "MessagingClientOptions.MessagingClientOptionsBuilder(proxyOptions=" + this.proxyOptions + ", sslContext=" + this.sslContext + ", errorProcessor=" + this.errorProcessor + ", keepAliveInterval$value=" + this.keepAliveInterval$value + ")";
        }
    }
}

