/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.messaging.serializers;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.service.ParserUtility;
import com.microsoft.azure.sdk.iot.service.messaging.FeedbackStatusCode;
import java.util.Date;

public class FeedbackRecordParser {
    private static final String DEVICE_ID_TAG = "deviceId";
    @Expose
    @SerializedName(value="deviceId")
    private String deviceId = null;
    private static final String ORIGINAL_MESSAGE_ID_TAG = "originalMessageId";
    @Expose
    @SerializedName(value="originalMessageId")
    private String originalMessageId = null;
    private static final String DESCRIPTION_TAG = "description";
    @Expose
    @SerializedName(value="description")
    private String description = null;
    private static final String STATUS_CODE_TAG = "statusCode";
    @Expose
    @SerializedName(value="statusCode")
    private FeedbackStatusCode statusCode = FeedbackStatusCode.unknown;
    private static final String DEVICE_GENERATION_ID_TAG = "deviceGenerationId";
    @Expose
    @SerializedName(value="deviceGenerationId")
    private String deviceGenerationId = null;
    private static final String ENQUEUED_TIME_UTC_TAG = "enqueuedTimeUtc";
    @Expose
    @SerializedName(value="enqueuedTimeUtc")
    private String enqueuedTimeUtc = null;

    FeedbackRecordParser() {
    }

    public Date getEnqueuedTimeUtcDate() {
        return ParserUtility.getDateTimeUtc(this.enqueuedTimeUtc);
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getOriginalMessageId() {
        return this.originalMessageId;
    }

    public String getDescription() {
        return this.description;
    }

    public FeedbackStatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getDeviceGenerationId() {
        return this.deviceGenerationId;
    }
}

