/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.query;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionStringBuilder;
import com.microsoft.azure.sdk.iot.service.auth.IotHubServiceSasToken;
import com.microsoft.azure.sdk.iot.service.auth.TokenCredentialCache;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.jobs.ScheduledJobStatus;
import com.microsoft.azure.sdk.iot.service.jobs.ScheduledJobType;
import com.microsoft.azure.sdk.iot.service.query.JobQueryResponse;
import com.microsoft.azure.sdk.iot.service.query.QueryClientOptions;
import com.microsoft.azure.sdk.iot.service.query.QueryPageOptions;
import com.microsoft.azure.sdk.iot.service.query.RawQueryResponse;
import com.microsoft.azure.sdk.iot.service.query.TwinQueryResponse;
import com.microsoft.azure.sdk.iot.service.query.serializers.QueryRequestParser;
import com.microsoft.azure.sdk.iot.service.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpMethod;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpRequest;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpResponse;
import java.io.IOException;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryClient {
    private static final Logger log = LoggerFactory.getLogger(QueryClient.class);
    private static final String CONTINUATION_TOKEN_KEY = "x-ms-continuation";
    private static final String PAGE_SIZE_KEY = "x-ms-max-item-count";
    private final String hostName;
    private TokenCredentialCache credentialCache;
    private AzureSasCredential azureSasCredential;
    private IotHubConnectionString iotHubConnectionString;
    private final QueryClientOptions options;

    public QueryClient(String connectionString) {
        this(connectionString, QueryClientOptions.builder().build());
    }

    public QueryClient(String connectionString, QueryClientOptions options) {
        if (connectionString == null || connectionString.isEmpty()) {
            throw new IllegalArgumentException("The provided connection string cannot be null or empty");
        }
        if (options == null) {
            throw new IllegalArgumentException("QueryClientOptions cannot be null for this constructor");
        }
        this.iotHubConnectionString = IotHubConnectionStringBuilder.createIotHubConnectionString(connectionString);
        this.hostName = this.iotHubConnectionString.getHostName();
        this.options = options;
        QueryClient.commonConstructorSetup();
    }

    public QueryClient(String hostName, TokenCredential credential) {
        this(hostName, credential, QueryClientOptions.builder().build());
    }

    public QueryClient(String hostName, TokenCredential credential, QueryClientOptions options) {
        Objects.requireNonNull(credential, "credential cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        this.options = options;
        this.credentialCache = new TokenCredentialCache(credential);
        this.hostName = hostName;
        QueryClient.commonConstructorSetup();
    }

    public QueryClient(String hostName, AzureSasCredential azureSasCredential) {
        this(hostName, azureSasCredential, QueryClientOptions.builder().build());
    }

    public QueryClient(String hostName, AzureSasCredential azureSasCredential, QueryClientOptions options) {
        Objects.requireNonNull(azureSasCredential, "azureSasCredential cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        this.options = options;
        this.azureSasCredential = azureSasCredential;
        this.hostName = hostName;
        QueryClient.commonConstructorSetup();
    }

    private static void commonConstructorSetup() {
        log.debug("Initialized a QueryClient instance client using SDK version {}", (Object)TransportUtils.serviceVersion);
    }

    public TwinQueryResponse queryTwins(String query) throws IOException, IotHubException {
        return this.queryTwins(query, QueryPageOptions.builder().build());
    }

    public TwinQueryResponse queryTwins(String query, QueryPageOptions options) throws IOException, IotHubException {
        if (query == null || query.isEmpty()) {
            throw new IllegalArgumentException("Query cannot be null or empty");
        }
        Objects.requireNonNull(options, "Options cannot be null");
        QueryRequestParser requestParser = new QueryRequestParser(query);
        byte[] payload = requestParser.toJson().getBytes(StandardCharsets.UTF_8);
        Proxy proxy = null;
        if (this.options.getProxyOptions() != null) {
            proxy = this.options.getProxyOptions().getProxy();
        }
        HttpRequest httpRequest = new HttpRequest(IotHubConnectionString.getUrlTwinQuery(this.hostName), HttpMethod.POST, payload, this.getAuthenticationToken(), proxy);
        this.setCommonHttpHeaders(httpRequest, options);
        HttpResponse httpResponse = httpRequest.send();
        String responsePayload = new String(httpResponse.getBody(), StandardCharsets.UTF_8);
        TwinQueryResponse twinQueryResponse = new TwinQueryResponse(responsePayload, this, query);
        String continuationToken = httpResponse.getHeaderFields().get(CONTINUATION_TOKEN_KEY);
        twinQueryResponse.setContinuationToken(continuationToken);
        return twinQueryResponse;
    }

    public JobQueryResponse queryJobs(String query) throws IOException, IotHubException {
        return this.queryJobs(query, QueryPageOptions.builder().build());
    }

    public JobQueryResponse queryJobs(String query, QueryPageOptions options) throws IOException, IotHubException {
        Objects.requireNonNull(options, "Options cannot be null");
        Proxy proxy = null;
        if (this.options.getProxyOptions() != null) {
            proxy = this.options.getProxyOptions().getProxy();
        }
        QueryRequestParser requestParser = new QueryRequestParser(query);
        byte[] payload = requestParser.toJson().getBytes(StandardCharsets.UTF_8);
        HttpRequest httpRequest = new HttpRequest(IotHubConnectionString.getUrlTwinQuery(this.hostName), HttpMethod.POST, payload, this.getAuthenticationToken(), proxy);
        this.setCommonHttpHeaders(httpRequest, options);
        HttpResponse httpResponse = httpRequest.send();
        String responsePayload = new String(httpResponse.getBody(), StandardCharsets.UTF_8);
        JobQueryResponse jobQueryResponse = new JobQueryResponse(responsePayload, this, query);
        String continuationToken = httpResponse.getHeaderFields().get(CONTINUATION_TOKEN_KEY);
        jobQueryResponse.setContinuationToken(continuationToken);
        return jobQueryResponse;
    }

    public JobQueryResponse queryJobs(ScheduledJobType jobType, ScheduledJobStatus jobStatus) throws IOException, IotHubException {
        return this.queryJobs(jobType, jobStatus, QueryPageOptions.builder().build());
    }

    public JobQueryResponse queryJobs(ScheduledJobType jobType, ScheduledJobStatus jobStatus, QueryPageOptions options) throws IOException, IotHubException {
        Objects.requireNonNull(options, "Options cannot be null");
        String jobTypeString = jobType == null ? null : jobType.toString();
        String jobStatusString = jobStatus == null ? null : jobStatus.toString();
        Proxy proxy = null;
        if (this.options.getProxyOptions() != null) {
            proxy = this.options.getProxyOptions().getProxy();
        }
        HttpRequest httpRequest = new HttpRequest(IotHubConnectionString.getUrlQuery(this.hostName, jobTypeString, jobStatusString), HttpMethod.GET, new byte[0], this.getAuthenticationToken(), proxy);
        this.setCommonHttpHeaders(httpRequest, options);
        HttpResponse httpResponse = httpRequest.send();
        String responsePayload = new String(httpResponse.getBody(), StandardCharsets.UTF_8);
        JobQueryResponse jobQueryResponse = new JobQueryResponse(responsePayload, this, jobType, jobStatus);
        String continuationToken = httpResponse.getHeaderFields().get(CONTINUATION_TOKEN_KEY);
        jobQueryResponse.setContinuationToken(continuationToken);
        return jobQueryResponse;
    }

    public RawQueryResponse queryRaw(String query) throws IOException, IotHubException {
        return this.queryRaw(query, QueryPageOptions.builder().build());
    }

    public RawQueryResponse queryRaw(String query, QueryPageOptions options) throws IOException, IotHubException {
        Objects.requireNonNull(options, "Options cannot be null");
        Proxy proxy = null;
        if (this.options.getProxyOptions() != null) {
            proxy = this.options.getProxyOptions().getProxy();
        }
        QueryRequestParser requestParser = new QueryRequestParser(query);
        byte[] payload = requestParser.toJson().getBytes(StandardCharsets.UTF_8);
        HttpRequest httpRequest = new HttpRequest(IotHubConnectionString.getUrlTwinQuery(this.hostName), HttpMethod.POST, payload, this.getAuthenticationToken(), proxy);
        this.setCommonHttpHeaders(httpRequest, options);
        HttpResponse httpResponse = httpRequest.send();
        String responsePayload = new String(httpResponse.getBody(), StandardCharsets.UTF_8);
        RawQueryResponse rawQueryResponse = new RawQueryResponse(responsePayload, this, query);
        String continuationToken = httpResponse.getHeaderFields().get(CONTINUATION_TOKEN_KEY);
        rawQueryResponse.setContinuationToken(continuationToken);
        return rawQueryResponse;
    }

    private String getAuthenticationToken() {
        if (this.credentialCache != null) {
            return this.credentialCache.getTokenString();
        }
        if (this.azureSasCredential != null) {
            return this.azureSasCredential.getSignature();
        }
        return new IotHubServiceSasToken(this.iotHubConnectionString).toString();
    }

    private void setCommonHttpHeaders(HttpRequest httpRequest, QueryPageOptions options) {
        httpRequest.setConnectTimeoutSeconds(this.options.getHttpConnectTimeoutSeconds());
        httpRequest.setReadTimeoutSeconds(this.options.getHttpReadTimeoutSeconds());
        if (options.getContinuationToken() != null) {
            httpRequest.setHeaderField(CONTINUATION_TOKEN_KEY, options.getContinuationToken());
        }
        httpRequest.setHeaderField(PAGE_SIZE_KEY, String.valueOf(options.getPageSize()));
    }
}

