/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.query;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.query.QueryClient;
import com.microsoft.azure.sdk.iot.service.query.QueryPageOptions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class RawQueryResponse {
    private final transient Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    Iterator<JsonObject> jsonObjects;
    String continuationToken = "";
    final QueryClient queryClient;
    final String originalQuery;

    public RawQueryResponse(String json, QueryClient queryClient, String originalQuery) {
        try {
            this.jsonObjects = Arrays.asList((Object[])this.gson.fromJson(json, JsonObject[].class)).iterator();
        }
        catch (JsonSyntaxException malformed) {
            throw new IllegalArgumentException("Malformed json:" + (Object)((Object)malformed));
        }
        this.queryClient = queryClient;
        this.originalQuery = originalQuery;
    }

    public boolean hasNext() {
        return this.jsonObjects.hasNext() || this.continuationToken != null;
    }

    public String next() throws IotHubException, IOException, NoSuchElementException {
        return this.next(QueryPageOptions.builder().build());
    }

    public String next(QueryPageOptions pageOptions) throws IotHubException, IOException {
        Objects.requireNonNull(pageOptions);
        try {
            return this.jsonObjects.next().toString();
        }
        catch (NoSuchElementException ex) {
            if (this.continuationToken == null) {
                throw ex;
            }
            QueryPageOptions nextPageOptions = QueryPageOptions.builder().continuationToken(this.continuationToken).pageSize(pageOptions.getPageSize()).build();
            RawQueryResponse nextPage = this.queryClient.queryRaw(this.originalQuery, nextPageOptions);
            this.jsonObjects = nextPage.jsonObjects;
            this.continuationToken = nextPage.continuationToken;
            return this.jsonObjects.next().toString();
        }
    }

    void setContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }
}

