/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.registry;

import com.microsoft.azure.sdk.iot.service.ParserUtility;
import com.microsoft.azure.sdk.iot.service.auth.AuthenticationType;
import com.microsoft.azure.sdk.iot.service.registry.DeviceStatus;
import com.microsoft.azure.sdk.iot.service.registry.RegistryIdentity;
import com.microsoft.azure.sdk.iot.service.registry.serializers.DeviceCapabilitiesParser;
import com.microsoft.azure.sdk.iot.service.registry.serializers.RegistryIdentityParser;
import com.microsoft.azure.sdk.iot.service.twin.DeviceCapabilities;
import java.util.ArrayList;
import java.util.List;

public class Device
extends RegistryIdentity {
    private DeviceStatus status;
    private String statusReason;
    private String statusUpdatedTime;
    private DeviceCapabilities capabilities;
    private String scope;
    private List<String> parentScopes = new ArrayList<String>();

    public Device(String deviceId) {
        this(deviceId, AuthenticationType.SAS);
    }

    public Device(String deviceId, AuthenticationType authenticationType) {
        super(deviceId, authenticationType);
        this.status = DeviceStatus.Enabled;
        this.statusUpdatedTime = "0001-01-01T00:00:00";
    }

    @Override
    RegistryIdentityParser toRegistryIdentityParser() {
        RegistryIdentityParser registryIdentityParser = super.toRegistryIdentityParser();
        registryIdentityParser.setStatus(this.status.toString());
        registryIdentityParser.setStatusReason(this.statusReason);
        registryIdentityParser.setStatusUpdatedTime(ParserUtility.getDateTimeUtc(this.statusUpdatedTime));
        if (this.capabilities != null) {
            registryIdentityParser.setCapabilities(new DeviceCapabilitiesParser());
            registryIdentityParser.getCapabilities().setIotEdge(this.capabilities.isIotEdge());
        }
        registryIdentityParser.setScope(this.scope);
        registryIdentityParser.setParentScopes(this.parentScopes);
        return registryIdentityParser;
    }

    Device(RegistryIdentityParser parser) throws IllegalArgumentException {
        super(parser);
        this.statusReason = parser.getStatusReason();
        if (parser.getCapabilities() != null) {
            this.capabilities = new DeviceCapabilities();
            this.capabilities.setIotEdge(parser.getCapabilities().getIotEdge());
        }
        if (parser.getStatusUpdatedTime() != null) {
            this.statusUpdatedTime = ParserUtility.getUTCDateStringFromDate(parser.getStatusUpdatedTime());
        }
        if (parser.getStatus() != null) {
            this.status = DeviceStatus.fromString(parser.getStatus());
        }
        this.scope = parser.getScope();
        this.parentScopes = parser.getParentScopes();
    }

    public DeviceStatus getStatus() {
        return this.status;
    }

    public void setStatus(DeviceStatus status) {
        this.status = status;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public String getStatusUpdatedTime() {
        return this.statusUpdatedTime;
    }

    public DeviceCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(DeviceCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public List<String> getParentScopes() {
        return this.parentScopes;
    }
}

