/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.registry;

import com.microsoft.azure.sdk.iot.service.auth.AuthenticationType;
import com.microsoft.azure.sdk.iot.service.registry.RegistryIdentity;
import com.microsoft.azure.sdk.iot.service.registry.serializers.RegistryIdentityParser;

public class Module
extends RegistryIdentity {
    private final String id;
    private final String managedBy;

    public Module(String deviceId, String moduleId) {
        this(deviceId, moduleId, AuthenticationType.SAS);
    }

    public Module(String deviceId, String moduleId, AuthenticationType authenticationType) {
        super(deviceId, authenticationType);
        if (moduleId == null || moduleId.isEmpty()) {
            throw new IllegalArgumentException("moduleId cannot be null or empty");
        }
        this.id = moduleId;
        this.managedBy = "";
    }

    Module(RegistryIdentityParser parser) throws IllegalArgumentException {
        super(parser);
        if (parser.getModuleId() == null) {
            throw new IllegalArgumentException("deviceParser must have a moduleId assigned");
        }
        this.id = parser.getModuleId();
        this.managedBy = parser.getManagedBy();
    }

    @Override
    RegistryIdentityParser toRegistryIdentityParser() {
        RegistryIdentityParser registryIdentityParser = super.toRegistryIdentityParser();
        registryIdentityParser.setModuleId(this.id);
        registryIdentityParser.setManagedBy(this.managedBy);
        return registryIdentityParser;
    }

    public String getId() {
        return this.id;
    }

    public String getManagedBy() {
        return this.managedBy;
    }
}

