/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.registry;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.google.gson.Gson;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionStringBuilder;
import com.microsoft.azure.sdk.iot.service.auth.IotHubServiceSasToken;
import com.microsoft.azure.sdk.iot.service.auth.TokenCredentialCache;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubExceptionManager;
import com.microsoft.azure.sdk.iot.service.registry.Device;
import com.microsoft.azure.sdk.iot.service.registry.Module;
import com.microsoft.azure.sdk.iot.service.registry.RegistryClientOptions;
import com.microsoft.azure.sdk.iot.service.registry.RegistryJob;
import com.microsoft.azure.sdk.iot.service.registry.RegistryStatistics;
import com.microsoft.azure.sdk.iot.service.registry.serializers.JobPropertiesParser;
import com.microsoft.azure.sdk.iot.service.registry.serializers.RegistryIdentityParser;
import com.microsoft.azure.sdk.iot.service.registry.serializers.RegistryStatisticsParser;
import com.microsoft.azure.sdk.iot.service.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpMethod;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpRequest;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpResponse;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistryClient {
    private static final Logger log = LoggerFactory.getLogger(RegistryClient.class);
    private final String hostName;
    private TokenCredentialCache credentialCache;
    private AzureSasCredential azureSasCredential;
    private IotHubConnectionString iotHubConnectionString;
    private final RegistryClientOptions options;

    public RegistryClient(String connectionString) {
        this(connectionString, RegistryClientOptions.builder().build());
    }

    public RegistryClient(String connectionString, RegistryClientOptions options) {
        if (connectionString == null || connectionString.isEmpty()) {
            throw new IllegalArgumentException("The provided connection string cannot be null or empty");
        }
        if (options == null) {
            throw new IllegalArgumentException("RegistryClientOptions cannot be null for this constructor");
        }
        this.iotHubConnectionString = IotHubConnectionStringBuilder.createIotHubConnectionString(connectionString);
        this.hostName = this.iotHubConnectionString.getHostName();
        this.options = options;
        RegistryClient.commonConstructorSetup();
    }

    public RegistryClient(String hostName, TokenCredential credential) {
        this(hostName, credential, RegistryClientOptions.builder().build());
    }

    public RegistryClient(String hostName, TokenCredential credential, RegistryClientOptions options) {
        Objects.requireNonNull(credential, "credential cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        this.options = options;
        this.credentialCache = new TokenCredentialCache(credential);
        this.hostName = hostName;
        RegistryClient.commonConstructorSetup();
    }

    public RegistryClient(String hostName, AzureSasCredential azureSasCredential) {
        this(hostName, azureSasCredential, RegistryClientOptions.builder().build());
    }

    public RegistryClient(String hostName, AzureSasCredential azureSasCredential, RegistryClientOptions options) {
        Objects.requireNonNull(azureSasCredential, "azureSasCredential cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        this.options = options;
        this.azureSasCredential = azureSasCredential;
        this.hostName = hostName;
        RegistryClient.commonConstructorSetup();
    }

    private static void commonConstructorSetup() {
        log.debug("Initialized a RegistryClient instance client using SDK version {}", (Object)TransportUtils.serviceVersion);
    }

    public Device addDevice(Device device) throws IOException, IotHubException {
        if (device == null) {
            throw new IllegalArgumentException("device cannot be null");
        }
        String deviceJson = device.toRegistryIdentityParser().toJson();
        URL url = IotHubConnectionString.getUrlDevice(this.hostName, device.getDeviceId());
        HttpRequest request = this.createRequest(url, HttpMethod.PUT, deviceJson.getBytes(StandardCharsets.UTF_8));
        HttpResponse response = request.send();
        IotHubExceptionManager.httpResponseVerification(response);
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        return new Device(new RegistryIdentityParser(bodyStr));
    }

    public Device getDevice(String deviceId) throws IOException, IotHubException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("deviceId cannot be null or empty");
        }
        URL url = IotHubConnectionString.getUrlDevice(this.hostName, deviceId);
        HttpRequest request = this.createRequest(url, HttpMethod.GET, new byte[0]);
        HttpResponse response = request.send();
        IotHubExceptionManager.httpResponseVerification(response);
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        return new Device(new RegistryIdentityParser(bodyStr));
    }

    public Device updateDevice(Device device) throws IOException, IotHubException {
        if (device == null) {
            throw new IllegalArgumentException("device cannot be null");
        }
        URL url = IotHubConnectionString.getUrlDevice(this.hostName, device.getDeviceId());
        HttpRequest request = this.createRequest(url, HttpMethod.PUT, device.toRegistryIdentityParser().toJson().getBytes(StandardCharsets.UTF_8));
        request.setHeaderField("If-Match", "*");
        HttpResponse response = request.send();
        IotHubExceptionManager.httpResponseVerification(response);
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        return new Device(new RegistryIdentityParser(bodyStr));
    }

    public void removeDevice(String deviceId) throws IOException, IotHubException {
        this.removeDeviceOperation(deviceId, "*");
    }

    public void removeDevice(Device device) throws IOException, IotHubException {
        if (device == null) {
            throw new IllegalArgumentException("device cannot be null or empty");
        }
        this.removeDeviceOperation(device.getDeviceId(), device.getETag());
    }

    private void removeDeviceOperation(String deviceId, String etag) throws IOException, IotHubException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("deviceId cannot be null or empty");
        }
        if (etag == null || etag.isEmpty()) {
            throw new IllegalArgumentException("etag cannot be null or empty");
        }
        URL url = IotHubConnectionString.getUrlDevice(this.hostName, deviceId);
        HttpRequest request = this.createRequest(url, HttpMethod.DELETE, new byte[0]);
        request.setHeaderField("If-Match", etag);
        HttpResponse response = request.send();
        IotHubExceptionManager.httpResponseVerification(response);
    }

    public RegistryStatistics getStatistics() throws IOException, IotHubException {
        URL url = IotHubConnectionString.getUrlDeviceStatistics(this.hostName);
        HttpRequest request = this.createRequest(url, HttpMethod.GET, new byte[0]);
        HttpResponse response = request.send();
        IotHubExceptionManager.httpResponseVerification(response);
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        return new RegistryStatistics(new RegistryStatisticsParser(bodyStr));
    }

    public Module addModule(Module module) throws IOException, IotHubException {
        if (module == null) {
            throw new IllegalArgumentException("module cannot be null");
        }
        String moduleJson = module.toRegistryIdentityParser().toJson();
        URL url = IotHubConnectionString.getUrlModule(this.hostName, module.getDeviceId(), module.getId());
        HttpRequest request = this.createRequest(url, HttpMethod.PUT, moduleJson.getBytes(StandardCharsets.UTF_8));
        HttpResponse response = request.send();
        IotHubExceptionManager.httpResponseVerification(response);
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        return new Module(new RegistryIdentityParser(bodyStr));
    }

    public Module getModule(String deviceId, String moduleId) throws IOException, IotHubException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("deviceId cannot be null or empty");
        }
        if (moduleId == null || moduleId.isEmpty()) {
            throw new IllegalArgumentException("moduleId cannot be null or empty");
        }
        URL url = IotHubConnectionString.getUrlModule(this.hostName, deviceId, moduleId);
        HttpRequest request = this.createRequest(url, HttpMethod.GET, new byte[0]);
        HttpResponse response = request.send();
        IotHubExceptionManager.httpResponseVerification(response);
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        return new Module(new RegistryIdentityParser(bodyStr));
    }

    public List<Module> getModulesOnDevice(String deviceId) throws IOException, IotHubException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("deviceId cannot be null or empty");
        }
        URL url = IotHubConnectionString.getUrlModulesOnDevice(this.hostName, deviceId);
        HttpRequest request = this.createRequest(url, HttpMethod.GET, new byte[0]);
        HttpResponse response = request.send();
        IotHubExceptionManager.httpResponseVerification(response);
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        Gson gson = new Gson();
        RegistryIdentityParser[] registryIdentityParsers = (RegistryIdentityParser[])gson.fromJson(bodyStr, RegistryIdentityParser[].class);
        ArrayList<Module> moduleList = new ArrayList<Module>();
        for (int i = 0; i < registryIdentityParsers.length; ++i) {
            moduleList.add(new Module(registryIdentityParsers[i]));
        }
        return moduleList;
    }

    public Module updateModule(Module module) throws IOException, IotHubException {
        if (module == null) {
            throw new IllegalArgumentException("module cannot be null");
        }
        URL url = IotHubConnectionString.getUrlModule(this.hostName, module.getDeviceId(), module.getId());
        HttpRequest request = this.createRequest(url, HttpMethod.PUT, module.toRegistryIdentityParser().toJson().getBytes(StandardCharsets.UTF_8));
        request.setHeaderField("If-Match", "*");
        HttpResponse response = request.send();
        IotHubExceptionManager.httpResponseVerification(response);
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        return new Module(new RegistryIdentityParser(bodyStr));
    }

    public void removeModule(String deviceId, String moduleId) throws IOException, IotHubException {
        this.removeModuleOperation(deviceId, moduleId, "*");
    }

    public void removeModule(Module module) throws IOException, IotHubException {
        if (module == null) {
            throw new IllegalArgumentException("module cannot be null or empty");
        }
        this.removeModuleOperation(module.getDeviceId(), module.getId(), module.getETag());
    }

    private void removeModuleOperation(String deviceId, String moduleId, String etag) throws IOException, IotHubException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("deviceId cannot be null or empty");
        }
        if (moduleId == null || moduleId.isEmpty()) {
            throw new IllegalArgumentException("moduleId cannot be null or empty");
        }
        if (etag == null || etag.isEmpty()) {
            throw new IllegalArgumentException("etag cannot be null or empty");
        }
        URL url = IotHubConnectionString.getUrlModule(this.hostName, deviceId, moduleId);
        HttpRequest request = this.createRequest(url, HttpMethod.DELETE, new byte[0]);
        request.setHeaderField("If-Match", etag);
        HttpResponse response = request.send();
        IotHubExceptionManager.httpResponseVerification(response);
    }

    public RegistryJob exportDevices(String exportBlobContainerUri, boolean excludeKeys) throws IOException, IotHubException {
        if (exportBlobContainerUri == null) {
            throw new IllegalArgumentException("Export blob uri cannot be null");
        }
        URL url = IotHubConnectionString.getUrlCreateExportImportJob(this.hostName);
        String jobPropertiesJson = this.createExportJobPropertiesJson(exportBlobContainerUri, excludeKeys);
        HttpRequest request = this.createRequest(url, HttpMethod.POST, jobPropertiesJson.getBytes(StandardCharsets.UTF_8));
        HttpResponse response = request.send();
        return this.processJobResponse(response);
    }

    public RegistryJob exportDevices(RegistryJob exportDevicesParameters) throws IOException, IotHubException {
        URL url = IotHubConnectionString.getUrlCreateExportImportJob(this.hostName);
        exportDevicesParameters.setType(RegistryJob.JobType.EXPORT);
        String jobPropertiesJson = exportDevicesParameters.toJobPropertiesParser().toJson();
        HttpRequest request = this.createRequest(url, HttpMethod.POST, jobPropertiesJson.getBytes(StandardCharsets.UTF_8));
        HttpResponse response = request.send();
        return this.processJobResponse(response);
    }

    public RegistryJob importDevices(String importBlobContainerUri, String outputBlobContainerUri) throws IOException, IotHubException {
        if (importBlobContainerUri == null || outputBlobContainerUri == null) {
            throw new IllegalArgumentException("Import blob uri or output blob uri cannot be null");
        }
        URL url = IotHubConnectionString.getUrlCreateExportImportJob(this.hostName);
        String jobPropertiesJson = this.createImportJobPropertiesJson(importBlobContainerUri, outputBlobContainerUri);
        HttpRequest request = this.createRequest(url, HttpMethod.POST, jobPropertiesJson.getBytes(StandardCharsets.UTF_8));
        HttpResponse response = request.send();
        return this.processJobResponse(response);
    }

    public RegistryJob importDevices(RegistryJob importDevicesParameters) throws IOException, IotHubException {
        URL url = IotHubConnectionString.getUrlCreateExportImportJob(this.hostName);
        importDevicesParameters.setType(RegistryJob.JobType.IMPORT);
        String jobPropertiesJson = importDevicesParameters.toJobPropertiesParser().toJson();
        HttpRequest request = this.createRequest(url, HttpMethod.POST, jobPropertiesJson.getBytes(StandardCharsets.UTF_8));
        HttpResponse response = request.send();
        return this.processJobResponse(response);
    }

    public RegistryJob getJob(String jobId) throws IOException, IotHubException {
        if (jobId == null) {
            throw new IllegalArgumentException("importExportJobId cannot be null");
        }
        URL url = IotHubConnectionString.getUrlImportExportJob(this.hostName, jobId);
        HttpRequest request = this.createRequest(url, HttpMethod.GET, new byte[0]);
        HttpResponse response = request.send();
        return this.processJobResponse(response);
    }

    private RegistryJob processJobResponse(HttpResponse response) throws IotHubException {
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        return new RegistryJob(new JobPropertiesParser(bodyStr));
    }

    private String createExportJobPropertiesJson(String exportBlobContainerUri, boolean excludeKeysInExport) {
        RegistryJob jobProperties = new RegistryJob();
        jobProperties.setType(RegistryJob.JobType.EXPORT);
        jobProperties.setOutputBlobContainerUri(exportBlobContainerUri);
        jobProperties.setExcludeKeysInExport(excludeKeysInExport);
        return jobProperties.toJobPropertiesParser().toJson();
    }

    private String createImportJobPropertiesJson(String importBlobContainerUri, String outputBlobContainerUri) {
        RegistryJob jobProperties = new RegistryJob();
        jobProperties.setType(RegistryJob.JobType.IMPORT);
        jobProperties.setInputBlobContainerUri(importBlobContainerUri);
        jobProperties.setOutputBlobContainerUri(outputBlobContainerUri);
        return jobProperties.toJobPropertiesParser().toJson();
    }

    private HttpRequest createRequest(URL url, HttpMethod method, byte[] payload) throws IOException {
        Proxy proxy = null;
        if (this.options.getProxyOptions() != null) {
            proxy = this.options.getProxyOptions().getProxy();
        }
        HttpRequest request = new HttpRequest(url, method, payload, this.getAuthenticationToken(), proxy);
        request.setReadTimeoutSeconds(this.options.getHttpReadTimeoutSeconds());
        request.setConnectTimeoutSeconds(this.options.getHttpConnectTimeoutSeconds());
        return request;
    }

    private String getAuthenticationToken() {
        if (this.credentialCache != null) {
            return this.credentialCache.getTokenString();
        }
        if (this.azureSasCredential != null) {
            return this.azureSasCredential.getSignature();
        }
        return new IotHubServiceSasToken(this.iotHubConnectionString).toString();
    }
}

