/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.registry;

import com.microsoft.azure.sdk.iot.service.ParserUtility;
import com.microsoft.azure.sdk.iot.service.auth.AuthenticationMechanism;
import com.microsoft.azure.sdk.iot.service.auth.AuthenticationType;
import com.microsoft.azure.sdk.iot.service.auth.SymmetricKey;
import com.microsoft.azure.sdk.iot.service.registry.DeviceConnectionState;
import com.microsoft.azure.sdk.iot.service.registry.serializers.AuthenticationParser;
import com.microsoft.azure.sdk.iot.service.registry.serializers.AuthenticationTypeParser;
import com.microsoft.azure.sdk.iot.service.registry.serializers.RegistryIdentityParser;
import com.microsoft.azure.sdk.iot.service.registry.serializers.SymmetricKeyParser;
import com.microsoft.azure.sdk.iot.service.registry.serializers.X509ThumbprintParser;

public class RegistryIdentity {
    final String UTC_TIME_DEFAULT = "0001-01-01T00:00:00";
    private static final String OFFSET_TIME_DEFAULT = "0001-01-01T00:00:00-00:00";
    private String deviceId;
    private String generationId;
    private DeviceConnectionState connectionState;
    private String connectionStateUpdatedTime;
    private String lastActivityTime;
    private long cloudToDeviceMessageCount;
    private String eTag;
    private AuthenticationMechanism authentication;

    RegistryIdentity(String deviceId, AuthenticationType authenticationType) {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("Device Id cannot be null or empty.");
        }
        if (authenticationType == null) {
            throw new IllegalArgumentException("authenticationType cannot be null or empty");
        }
        this.setPropertiesToDefaultValues();
        this.deviceId = deviceId;
        this.authentication = new AuthenticationMechanism(authenticationType);
    }

    public SymmetricKey getSymmetricKey() {
        if (this.authentication == null) {
            return null;
        }
        return this.authentication.getSymmetricKey();
    }

    public void setSymmetricKey(SymmetricKey symmetricKey) throws IllegalArgumentException {
        if (this.authentication == null) {
            this.authentication = new AuthenticationMechanism(symmetricKey);
        } else {
            this.authentication.setSymmetricKey(symmetricKey);
        }
    }

    public String getPrimaryKey() {
        if (this.getSymmetricKey() == null) {
            return null;
        }
        return this.getSymmetricKey().getPrimaryKey();
    }

    public String getSecondaryKey() {
        if (this.getSymmetricKey() == null) {
            return null;
        }
        return this.getSymmetricKey().getSecondaryKey();
    }

    public final void setThumbprint(String primaryThumbprint, String secondaryThumbprint) {
        if (this.authentication == null) {
            this.authentication = new AuthenticationMechanism(AuthenticationType.SELF_SIGNED);
        }
        this.authentication.setPrimaryThumbprint(primaryThumbprint);
        this.authentication.setSecondaryThumbprint(secondaryThumbprint);
    }

    public String getPrimaryThumbprint() {
        if (this.authentication == null) {
            return null;
        }
        return this.authentication.getPrimaryThumbprint();
    }

    public String getSecondaryThumbprint() {
        if (this.authentication == null) {
            return null;
        }
        return this.authentication.getSecondaryThumbprint();
    }

    public AuthenticationType getAuthenticationType() {
        if (this.authentication == null) {
            return null;
        }
        return this.authentication.getAuthenticationType();
    }

    RegistryIdentityParser toRegistryIdentityParser() {
        RegistryIdentityParser registryIdentityParser = new RegistryIdentityParser();
        registryIdentityParser.setCloudToDeviceMessageCount(this.cloudToDeviceMessageCount);
        registryIdentityParser.setConnectionState(this.connectionState.toString());
        registryIdentityParser.setConnectionStateUpdatedTime(ParserUtility.getDateTimeUtc(this.connectionStateUpdatedTime));
        registryIdentityParser.setDeviceId(this.deviceId);
        registryIdentityParser.setETag(this.eTag);
        registryIdentityParser.setLastActivityTime(ParserUtility.getDateTimeUtc(this.lastActivityTime));
        registryIdentityParser.setGenerationId(this.generationId);
        registryIdentityParser.setAuthenticationParser(new AuthenticationParser());
        registryIdentityParser.getAuthenticationParser().setType(AuthenticationTypeParser.valueOf(this.authentication.getAuthenticationType().toString()));
        if (this.authentication.getAuthenticationType() != AuthenticationType.CERTIFICATE_AUTHORITY) {
            if (this.authentication.getAuthenticationType() == AuthenticationType.SELF_SIGNED) {
                registryIdentityParser.getAuthenticationParser().setThumbprint(new X509ThumbprintParser(this.getPrimaryThumbprint(), this.getSecondaryThumbprint()));
            } else if (this.authentication.getAuthenticationType() == AuthenticationType.SAS) {
                registryIdentityParser.getAuthenticationParser().setSymmetricKey(new SymmetricKeyParser(this.getPrimaryKey(), this.getSecondaryKey()));
            }
        }
        return registryIdentityParser;
    }

    RegistryIdentity(RegistryIdentityParser parser) throws IllegalArgumentException {
        if (parser.getDeviceId() == null) {
            throw new IllegalArgumentException("deviceParser must have a deviceId assigned");
        }
        this.deviceId = parser.getDeviceId();
        this.cloudToDeviceMessageCount = parser.getCloudToDeviceMessageCount();
        this.deviceId = parser.getDeviceId();
        this.eTag = parser.getETag();
        this.generationId = parser.getGenerationId();
        if (parser.getConnectionStateUpdatedTime() != null) {
            this.connectionStateUpdatedTime = ParserUtility.getUTCDateStringFromDate(parser.getConnectionStateUpdatedTime());
        }
        if (parser.getLastActivityTime() != null) {
            this.lastActivityTime = ParserUtility.getUTCDateStringFromDate(parser.getLastActivityTime());
        }
        if (parser.getConnectionState() != null) {
            this.connectionState = DeviceConnectionState.valueOf(parser.getConnectionState());
        }
        if (parser.getAuthenticationParser() != null && parser.getAuthenticationParser().getType() != null) {
            AuthenticationType authenticationType = AuthenticationType.valueOf(parser.getAuthenticationParser().getType().toString());
            this.authentication = new AuthenticationMechanism(authenticationType);
            if (parser.getAuthenticationParser().getThumbprint() != null && (parser.getAuthenticationParser().getThumbprint().getPrimaryThumbprint() != null || parser.getAuthenticationParser().getThumbprint().getSecondaryThumbprint() != null)) {
                this.setThumbprint(parser.getAuthenticationParser().getThumbprint().getPrimaryThumbprint(), parser.getAuthenticationParser().getThumbprint().getSecondaryThumbprint());
            } else if (parser.getAuthenticationParser().getSymmetricKey() != null && this.getSymmetricKey() != null) {
                this.getSymmetricKey().setPrimaryKey(parser.getAuthenticationParser().getSymmetricKey().getPrimaryKey());
                this.getSymmetricKey().setSecondaryKey(parser.getAuthenticationParser().getSymmetricKey().getSecondaryKey());
            }
        }
    }

    private void setPropertiesToDefaultValues() {
        this.generationId = "";
        this.eTag = "";
        this.connectionState = DeviceConnectionState.Disconnected;
        this.connectionStateUpdatedTime = "0001-01-01T00:00:00";
        this.lastActivityTime = OFFSET_TIME_DEFAULT;
        this.cloudToDeviceMessageCount = 0L;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getGenerationId() {
        return this.generationId;
    }

    public DeviceConnectionState getConnectionState() {
        return this.connectionState;
    }

    public String getConnectionStateUpdatedTime() {
        return this.connectionStateUpdatedTime;
    }

    public String getLastActivityTime() {
        return this.lastActivityTime;
    }

    public long getCloudToDeviceMessageCount() {
        return this.cloudToDeviceMessageCount;
    }

    public String getETag() {
        return this.eTag;
    }
}

