/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.registry;

import com.microsoft.azure.sdk.iot.service.registry.ManagedIdentity;
import com.microsoft.azure.sdk.iot.service.registry.StorageAuthenticationType;
import com.microsoft.azure.sdk.iot.service.registry.serializers.JobPropertiesParser;
import java.util.Date;
import lombok.NonNull;

public class RegistryJob {
    @NonNull
    private String jobId;
    private Date startTimeUtc;
    private Date endTimeUtc;
    private JobType type;
    private JobStatus status;
    private int progress;
    private String inputBlobContainerUri;
    private String outputBlobContainerUri;
    private boolean excludeKeysInExport;
    private String failureReason;
    private StorageAuthenticationType storageAuthenticationType;
    private ManagedIdentity identity;

    public RegistryJob() {
        this.setJobId("");
    }

    public boolean getExcludeKeysInExport() {
        return this.excludeKeysInExport;
    }

    public void setExcludeKeysInExport(boolean excludeKeysInExport) {
        this.excludeKeysInExport = excludeKeysInExport;
    }

    RegistryJob(JobPropertiesParser parser) {
        this.endTimeUtc = parser.getEndTimeUtc();
        this.excludeKeysInExport = parser.isExcludeKeysInExport();
        this.inputBlobContainerUri = parser.getInputBlobContainerUri();
        this.failureReason = parser.getFailureReason();
        this.outputBlobContainerUri = parser.getOutputBlobContainerUri();
        this.storageAuthenticationType = parser.getStorageAuthenticationType();
        this.jobId = parser.getJobId();
        this.progress = parser.getProgress();
        this.startTimeUtc = parser.getStartTimeUtc();
        this.identity = parser.getIdentity();
        if (parser.getStatus() != null) {
            this.status = JobStatus.valueOf(parser.getStatus().toUpperCase());
        }
        if (parser.getType() != null) {
            this.type = JobType.valueOf(parser.getType().toUpperCase());
        }
    }

    JobPropertiesParser toJobPropertiesParser() {
        JobPropertiesParser jobPropertiesParser = new JobPropertiesParser();
        jobPropertiesParser.setEndTimeUtc(this.endTimeUtc);
        jobPropertiesParser.setExcludeKeysInExport(this.excludeKeysInExport);
        jobPropertiesParser.setFailureReason(this.failureReason);
        jobPropertiesParser.setInputBlobContainerUri(this.inputBlobContainerUri);
        jobPropertiesParser.setOutputBlobContainerUri(this.outputBlobContainerUri);
        jobPropertiesParser.setStorageAuthenticationType(this.storageAuthenticationType);
        jobPropertiesParser.setJobId(this.jobId);
        jobPropertiesParser.setProgress(this.progress);
        jobPropertiesParser.setStartTimeUtc(this.startTimeUtc);
        jobPropertiesParser.setIdentity(this.identity);
        if (this.status != null) {
            jobPropertiesParser.setStatus(this.status.toString());
        }
        if (this.type != null) {
            jobPropertiesParser.setType(this.type.toString().toLowerCase());
        }
        return jobPropertiesParser;
    }

    public static RegistryJob createForImportJob(String inputBlobContainerUri, String outputBlobContainerUri) {
        StorageAuthenticationType storageAuthenticationType = StorageAuthenticationType.KEY;
        return RegistryJob.createForImportJob(inputBlobContainerUri, outputBlobContainerUri, storageAuthenticationType);
    }

    public static RegistryJob createForImportJob(String inputBlobContainerUri, String outputBlobContainerUri, StorageAuthenticationType storageAuthenticationType) {
        RegistryJob importJobProperties = new RegistryJob();
        importJobProperties.setType(JobType.IMPORT);
        importJobProperties.setInputBlobContainerUri(inputBlobContainerUri);
        importJobProperties.setOutputBlobContainerUri(outputBlobContainerUri);
        importJobProperties.setStorageAuthenticationType(storageAuthenticationType);
        return importJobProperties;
    }

    public static RegistryJob createForImportJob(String inputBlobContainerUri, String outputBlobContainerUri, StorageAuthenticationType storageAuthenticationType, ManagedIdentity identity) {
        RegistryJob importJobProperties = new RegistryJob();
        importJobProperties.setType(JobType.IMPORT);
        importJobProperties.setInputBlobContainerUri(inputBlobContainerUri);
        importJobProperties.setOutputBlobContainerUri(outputBlobContainerUri);
        importJobProperties.setStorageAuthenticationType(storageAuthenticationType);
        importJobProperties.setIdentity(identity);
        return importJobProperties;
    }

    public static RegistryJob createForExportJob(String outputBlobContainerUri, Boolean excludeKeysInExport) {
        StorageAuthenticationType storageAuthenticationType = StorageAuthenticationType.KEY;
        return RegistryJob.createForExportJob(outputBlobContainerUri, excludeKeysInExport, storageAuthenticationType);
    }

    public static RegistryJob createForExportJob(String outputBlobContainerUri, Boolean excludeKeysInExport, StorageAuthenticationType storageAuthenticationType) {
        RegistryJob exportJobProperties = new RegistryJob();
        exportJobProperties.setType(JobType.EXPORT);
        exportJobProperties.setOutputBlobContainerUri(outputBlobContainerUri);
        exportJobProperties.setExcludeKeysInExport(excludeKeysInExport);
        exportJobProperties.setStorageAuthenticationType(storageAuthenticationType);
        return exportJobProperties;
    }

    public static RegistryJob createForExportJob(String outputBlobContainerUri, Boolean excludeKeysInExport, StorageAuthenticationType storageAuthenticationType, ManagedIdentity identity) {
        RegistryJob exportJobProperties = new RegistryJob();
        exportJobProperties.setType(JobType.EXPORT);
        exportJobProperties.setOutputBlobContainerUri(outputBlobContainerUri);
        exportJobProperties.setExcludeKeysInExport(excludeKeysInExport);
        exportJobProperties.setStorageAuthenticationType(storageAuthenticationType);
        exportJobProperties.setIdentity(identity);
        return exportJobProperties;
    }

    @NonNull
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(@NonNull String jobId) {
        if (jobId == null) {
            throw new NullPointerException("jobId is marked non-null but is null");
        }
        this.jobId = jobId;
    }

    public Date getStartTimeUtc() {
        return this.startTimeUtc;
    }

    public void setStartTimeUtc(Date startTimeUtc) {
        this.startTimeUtc = startTimeUtc;
    }

    public Date getEndTimeUtc() {
        return this.endTimeUtc;
    }

    public void setEndTimeUtc(Date endTimeUtc) {
        this.endTimeUtc = endTimeUtc;
    }

    public JobType getType() {
        return this.type;
    }

    public void setType(JobType type) {
        this.type = type;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public void setStatus(JobStatus status) {
        this.status = status;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public String getInputBlobContainerUri() {
        return this.inputBlobContainerUri;
    }

    public void setInputBlobContainerUri(String inputBlobContainerUri) {
        this.inputBlobContainerUri = inputBlobContainerUri;
    }

    public String getOutputBlobContainerUri() {
        return this.outputBlobContainerUri;
    }

    public void setOutputBlobContainerUri(String outputBlobContainerUri) {
        this.outputBlobContainerUri = outputBlobContainerUri;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public StorageAuthenticationType getStorageAuthenticationType() {
        return this.storageAuthenticationType;
    }

    public void setStorageAuthenticationType(StorageAuthenticationType storageAuthenticationType) {
        this.storageAuthenticationType = storageAuthenticationType;
    }

    public ManagedIdentity getIdentity() {
        return this.identity;
    }

    public void setIdentity(ManagedIdentity identity) {
        this.identity = identity;
    }

    public static enum JobType {
        UNKNOWN,
        EXPORT,
        IMPORT;

    }

    public static enum JobStatus {
        UNKNOWN,
        ENQUEUED,
        RUNNING,
        COMPLETED,
        FAILED,
        CANCELLED;

    }
}

