/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.registry.serializers;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.service.ParserUtility;
import com.microsoft.azure.sdk.iot.service.registry.ManagedIdentity;
import com.microsoft.azure.sdk.iot.service.registry.StorageAuthenticationType;
import java.util.Date;

public class JobPropertiesParser {
    private static final transient Gson gson = new Gson();
    private static final String JOB_ID_NAME = "jobId";
    @Expose
    @SerializedName(value="jobId")
    private String jobId;
    private static final String START_TIME_UTC_NAME = "startTimeUtc";
    @Expose
    @SerializedName(value="startTimeUtc")
    private String startTimeUtcString;
    private transient Date startTimeUtc;
    private static final String END_TIME_UTC_NAME = "endTimeUtc";
    @Expose
    @SerializedName(value="endTimeUtc")
    private String endTimeUtcString;
    private transient Date endTimeUtc;
    private static final String TYPE_NAME = "type";
    @Expose
    @SerializedName(value="type")
    private String type;
    private static final String STATUS_NAME = "status";
    @Expose
    @SerializedName(value="status")
    private String status;
    private static final String PROGRESS_NAME = "progress";
    @Expose
    @SerializedName(value="progress")
    private int progress;
    private static final String INPUT_BLOB_CONTAINER_URI_NAME = "inputBlobContainerUri";
    @Expose
    @SerializedName(value="inputBlobContainerUri")
    private String inputBlobContainerUri;
    private static final String OUTPUT_BLOB_CONTAINER_URI_NAME = "outputBlobContainerUri";
    @Expose
    @SerializedName(value="outputBlobContainerUri")
    private String outputBlobContainerUri;
    private static final String EXCLUDE_KEYS_IN_EXPORT_NAME = "excludeKeysInExport";
    @Expose
    @SerializedName(value="excludeKeysInExport")
    private boolean excludeKeysInExport;
    private static final String FAILURE_REASON_NAME = "failureReason";
    @Expose
    @SerializedName(value="failureReason")
    private String failureReason;
    private static final String STORAGE_AUTHENTICATION_TYPE = "storageAuthenticationType";
    @Expose
    @SerializedName(value="storageAuthenticationType")
    private StorageAuthenticationType storageAuthenticationType;
    private static final String IDENTITY = "identity";
    @Expose
    @SerializedName(value="identity")
    private ManagedIdentity identity;

    public JobPropertiesParser() {
    }

    public JobPropertiesParser(String json) throws IllegalArgumentException {
        JobPropertiesParser parser;
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("The provided json cannot be null or empty");
        }
        try {
            parser = (JobPropertiesParser)gson.fromJson(json, JobPropertiesParser.class);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException("The provided json could not be parsed");
        }
        if (parser.getJobId() == null || parser.getJobId().isEmpty()) {
            throw new IllegalArgumentException("The provided json is missing the jobId field");
        }
        this.inputBlobContainerUri = parser.inputBlobContainerUri;
        this.type = parser.type;
        this.status = parser.status;
        this.jobId = parser.jobId;
        this.excludeKeysInExport = parser.excludeKeysInExport;
        this.progress = parser.progress;
        this.outputBlobContainerUri = parser.outputBlobContainerUri;
        this.failureReason = parser.failureReason;
        this.storageAuthenticationType = parser.storageAuthenticationType;
        this.identity = parser.identity;
        if (parser.endTimeUtcString != null) {
            this.endTimeUtcString = parser.endTimeUtcString;
            this.endTimeUtc = ParserUtility.getDateTimeUtc(parser.endTimeUtcString);
        }
        if (parser.startTimeUtcString != null) {
            this.startTimeUtcString = parser.startTimeUtcString;
            this.startTimeUtc = ParserUtility.getDateTimeUtc(parser.startTimeUtcString);
        }
    }

    public String toJson() {
        if (this.startTimeUtc != null) {
            this.startTimeUtcString = ParserUtility.getUTCDateStringFromDate(this.startTimeUtc);
        }
        if (this.endTimeUtc != null) {
            this.endTimeUtcString = ParserUtility.getUTCDateStringFromDate(this.endTimeUtc);
        }
        return gson.toJson((Object)this);
    }

    public void setStartTimeUtc(Date startTimeUtc) {
        this.startTimeUtc = startTimeUtc;
        this.startTimeUtcString = startTimeUtc == null ? null : ParserUtility.getUTCDateStringFromDate(startTimeUtc);
    }

    public void setEndTimeUtc(Date endTimeUtc) {
        this.endTimeUtc = endTimeUtc;
        this.endTimeUtcString = endTimeUtc == null ? null : ParserUtility.getUTCDateStringFromDate(endTimeUtc);
    }

    public Date getStartTimeUtc() {
        return this.startTimeUtc;
    }

    public Date getEndTimeUtc() {
        return this.endTimeUtc;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setInputBlobContainerUri(String inputBlobContainerUri) {
        this.inputBlobContainerUri = inputBlobContainerUri;
    }

    public String getInputBlobContainerUri() {
        return this.inputBlobContainerUri;
    }

    public void setOutputBlobContainerUri(String outputBlobContainerUri) {
        this.outputBlobContainerUri = outputBlobContainerUri;
    }

    public String getOutputBlobContainerUri() {
        return this.outputBlobContainerUri;
    }

    public void setExcludeKeysInExport(boolean excludeKeysInExport) {
        this.excludeKeysInExport = excludeKeysInExport;
    }

    public boolean isExcludeKeysInExport() {
        return this.excludeKeysInExport;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setStorageAuthenticationType(StorageAuthenticationType storageAuthenticationType) {
        this.storageAuthenticationType = storageAuthenticationType;
    }

    public StorageAuthenticationType getStorageAuthenticationType() {
        return this.storageAuthenticationType;
    }

    public void setIdentity(ManagedIdentity identity) {
        this.identity = identity;
    }

    public ManagedIdentity getIdentity() {
        return this.identity;
    }
}

