/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.registry.serializers;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.service.ParserUtility;
import com.microsoft.azure.sdk.iot.service.registry.serializers.AuthenticationParser;
import com.microsoft.azure.sdk.iot.service.registry.serializers.DeviceCapabilitiesParser;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RegistryIdentityParser {
    private static final String E_TAG_NAME = "etag";
    @Expose
    @SerializedName(value="etag")
    private String eTag;
    private static final String DEVICE_ID_NAME = "deviceId";
    @Expose
    @SerializedName(value="deviceId")
    private String deviceId;
    private static final String MODULE_ID_NAME = "moduleId";
    @Expose
    @SerializedName(value="moduleId")
    private String moduleId;
    private static final String GENERATION_ID_NAME = "generationId";
    @Expose
    @SerializedName(value="generationId")
    private String generationId;
    private static final String STATUS_NAME = "status";
    @Expose
    @SerializedName(value="status")
    private String status;
    private static final String STATUS_REASON = "statusReason";
    @Expose
    @SerializedName(value="statusReason")
    private String statusReason;
    private static final String STATUS_UPDATED_TIME_NAME = "statusUpdatedTime";
    @Expose(deserialize=false)
    @SerializedName(value="statusUpdatedTime")
    private String statusUpdatedTimeString;
    private transient Date statusUpdatedTime;
    private static final String CONNECTION_STATE_NAME = "connectionState";
    @Expose
    @SerializedName(value="connectionState")
    private String connectionState;
    private static final String CONNECTION_STATE_UPDATED_TIME_NAME = "connectionStateUpdatedTime";
    @Expose(deserialize=false)
    @SerializedName(value="connectionStateUpdatedTime")
    private String connectionStateUpdatedTimeString;
    private transient Date connectionStateUpdatedTime;
    private static final String LAST_ACTIVITY_TIME_NAME = "lastActivityTime";
    @Expose(deserialize=false)
    @SerializedName(value="lastActivityTime")
    private String lastActivityTimeString;
    private transient Date lastActivityTime;
    private static final String CLOUD_TO_MESSAGE_COUNT_NAME = "cloudToDeviceMessageCount";
    @Expose
    @SerializedName(value="cloudToDeviceMessageCount")
    private long cloudToDeviceMessageCount;
    private static final String AUTHENTICATION_NAME = "authentication";
    @Expose
    @SerializedName(value="authentication")
    private AuthenticationParser authenticationParser;
    private static final String MANAGED_BY = "managedBy";
    @Expose
    @SerializedName(value="managedBy")
    private String managedBy;
    private static final String CAPABILITIES_NAME = "capabilities";
    @Expose
    @SerializedName(value="capabilities")
    private DeviceCapabilitiesParser capabilities;
    private static final String SCOPE_NAME = "deviceScope";
    @Expose
    @SerializedName(value="deviceScope")
    private String scope;
    private static final String PARENT_SCOPES_NAMES = "parentScopes";
    @Expose
    @SerializedName(value="parentScopes")
    private List<String> parentScopes = new ArrayList<String>();
    private final transient Gson gson = new Gson();

    public String toJson() {
        if (this.statusUpdatedTime != null) {
            this.statusUpdatedTimeString = ParserUtility.getUTCDateStringFromDate(this.statusUpdatedTime);
        }
        if (this.connectionStateUpdatedTime != null) {
            this.connectionStateUpdatedTimeString = ParserUtility.getUTCDateStringFromDate(this.connectionStateUpdatedTime);
        }
        if (this.lastActivityTime != null) {
            this.lastActivityTimeString = ParserUtility.getUTCDateStringFromDate(this.lastActivityTime);
        }
        return this.gson.toJson((Object)this);
    }

    public RegistryIdentityParser() {
    }

    public RegistryIdentityParser(String json) {
        RegistryIdentityParser registryIdentityParser;
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("The provided json cannot be null or empty.");
        }
        try {
            registryIdentityParser = (RegistryIdentityParser)this.gson.fromJson(json, RegistryIdentityParser.class);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException("The provided json could not be parsed.");
        }
        if (registryIdentityParser.deviceId == null || registryIdentityParser.deviceId.isEmpty()) {
            throw new IllegalArgumentException("The provided json must contain the field for deviceId and its value may not be empty.");
        }
        if (registryIdentityParser.authenticationParser == null) {
            throw new IllegalArgumentException("The provided json must contain the field for authentication and its value may not be empty.");
        }
        this.authenticationParser = registryIdentityParser.authenticationParser;
        this.connectionState = registryIdentityParser.connectionState;
        this.deviceId = registryIdentityParser.deviceId;
        this.moduleId = registryIdentityParser.moduleId;
        this.statusReason = registryIdentityParser.statusReason;
        this.cloudToDeviceMessageCount = registryIdentityParser.cloudToDeviceMessageCount;
        this.connectionState = registryIdentityParser.connectionState;
        this.generationId = registryIdentityParser.generationId;
        this.eTag = registryIdentityParser.eTag;
        this.status = registryIdentityParser.status;
        this.managedBy = registryIdentityParser.managedBy;
        this.capabilities = registryIdentityParser.capabilities;
        this.scope = registryIdentityParser.scope;
        this.parentScopes = registryIdentityParser.parentScopes;
        if (registryIdentityParser.lastActivityTimeString != null) {
            this.lastActivityTimeString = registryIdentityParser.lastActivityTimeString;
            this.lastActivityTime = ParserUtility.getDateTimeUtc(registryIdentityParser.lastActivityTimeString);
        }
        if (registryIdentityParser.connectionStateUpdatedTimeString != null) {
            this.connectionStateUpdatedTimeString = registryIdentityParser.connectionStateUpdatedTimeString;
            this.connectionStateUpdatedTime = ParserUtility.getDateTimeUtc(registryIdentityParser.connectionStateUpdatedTimeString);
        }
        if (registryIdentityParser.statusUpdatedTimeString != null) {
            this.statusUpdatedTimeString = registryIdentityParser.statusUpdatedTimeString;
            this.statusUpdatedTime = ParserUtility.getDateTimeUtc(registryIdentityParser.statusUpdatedTimeString);
        }
    }

    public Date getStatusUpdatedTime() {
        return this.statusUpdatedTime;
    }

    public void setStatusUpdatedTime(Date statusUpdatedTime) {
        this.statusUpdatedTime = statusUpdatedTime;
        this.statusUpdatedTimeString = statusUpdatedTime == null ? null : ParserUtility.getUTCDateStringFromDate(statusUpdatedTime);
    }

    public Date getConnectionStateUpdatedTime() {
        return this.connectionStateUpdatedTime;
    }

    public void setConnectionStateUpdatedTime(Date connectionStateUpdatedTime) {
        this.connectionStateUpdatedTime = connectionStateUpdatedTime;
        this.connectionStateUpdatedTimeString = connectionStateUpdatedTime == null ? null : ParserUtility.getUTCDateStringFromDate(connectionStateUpdatedTime);
    }

    public Date getLastActivityTime() {
        return this.lastActivityTime;
    }

    public void setLastActivityTime(Date lastActivityTime) {
        this.lastActivityTime = lastActivityTime;
        this.lastActivityTimeString = lastActivityTime == null ? null : ParserUtility.getUTCDateStringFromDate(lastActivityTime);
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public String getGenerationId() {
        return this.generationId;
    }

    public void setGenerationId(String generationId) {
        this.generationId = generationId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public String getStatusUpdatedTimeString() {
        return this.statusUpdatedTimeString;
    }

    public void setStatusUpdatedTimeString(String statusUpdatedTimeString) {
        this.statusUpdatedTimeString = statusUpdatedTimeString;
    }

    public String getConnectionState() {
        return this.connectionState;
    }

    public void setConnectionState(String connectionState) {
        this.connectionState = connectionState;
    }

    public long getCloudToDeviceMessageCount() {
        return this.cloudToDeviceMessageCount;
    }

    public void setCloudToDeviceMessageCount(long cloudToDeviceMessageCount) {
        this.cloudToDeviceMessageCount = cloudToDeviceMessageCount;
    }

    public AuthenticationParser getAuthenticationParser() {
        return this.authenticationParser;
    }

    public void setAuthenticationParser(AuthenticationParser authenticationParser) {
        this.authenticationParser = authenticationParser;
    }

    public String getManagedBy() {
        return this.managedBy;
    }

    public void setManagedBy(String managedBy) {
        this.managedBy = managedBy;
    }

    public DeviceCapabilitiesParser getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(DeviceCapabilitiesParser capabilities) {
        this.capabilities = capabilities;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public List<String> getParentScopes() {
        return this.parentScopes;
    }

    public void setParentScopes(List<String> parentScopes) {
        this.parentScopes = parentScopes;
    }
}

