/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.registry.serializers;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;

public class SymmetricKeyParser {
    private final transient Gson gson = new Gson();
    private static final String PRIMARY_KEY_SERIALIZED_NAME = "primaryKey";
    @SerializedName(value="primaryKey")
    private String primaryKey;
    private static final String SECONDARY_KEY_SERIALIZED_NAME = "secondaryKey";
    @SerializedName(value="secondaryKey")
    private String secondaryKey;

    public SymmetricKeyParser() {
    }

    public SymmetricKeyParser(String primaryKey, String secondaryKey) {
        this.primaryKey = primaryKey;
        this.secondaryKey = secondaryKey;
    }

    public SymmetricKeyParser(String json) {
        SymmetricKeyParser parser;
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("The provided json cannot be null or empty");
        }
        try {
            parser = (SymmetricKeyParser)this.gson.fromJson(json, SymmetricKeyParser.class);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException("The provided json could not be parsed");
        }
        if (parser.getPrimaryKey() == null || parser.getPrimaryKey().isEmpty() || parser.getSecondaryKey() == null || parser.getSecondaryKey().isEmpty()) {
            throw new IllegalArgumentException("Both the primary key and secondary key must be present and have a value in the provided json.");
        }
        this.primaryKey = parser.primaryKey;
        this.secondaryKey = parser.secondaryKey;
    }

    public String toJson() {
        return this.gson.toJson((Object)this);
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getSecondaryKey() {
        return this.secondaryKey;
    }

    public void setSecondaryKey(String secondaryKey) {
        this.secondaryKey = secondaryKey;
    }
}

