/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.amqps;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.microsoft.azure.proton.transport.proxy.ProxyHandler;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyHandlerImpl;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyImpl;
import com.microsoft.azure.proton.transport.ws.impl.WebSocketImpl;
import com.microsoft.azure.sdk.iot.service.ProxyOptions;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionStringBuilder;
import com.microsoft.azure.sdk.iot.service.auth.IotHubSSLContext;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.messaging.ErrorContext;
import com.microsoft.azure.sdk.iot.service.messaging.IotHubServiceClientProtocol;
import com.microsoft.azure.sdk.iot.service.transport.amqps.CbsSessionHandler;
import com.microsoft.azure.sdk.iot.service.transport.amqps.CbsSessionStateCallback;
import com.microsoft.azure.sdk.iot.service.transport.amqps.ErrorLoggingBaseHandlerWithCleanup;
import com.microsoft.azure.sdk.iot.service.transport.amqps.ProtonJExceptionParser;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.engine.impl.TransportLayer;
import org.apache.qpid.proton.reactor.Handshaker;
import org.apache.qpid.proton.reactor.Reactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AmqpConnectionHandler
extends ErrorLoggingBaseHandlerWithCleanup
implements CbsSessionStateCallback {
    private static final Logger log = LoggerFactory.getLogger(AmqpConnectionHandler.class);
    private static final int AMQPS_PORT = 5671;
    private static final int AMQPS_WS_PORT = 443;
    private static final String WEB_SOCKET_PATH = "/$iothub/websocket";
    private static final String WEB_SOCKET_SUB_PROTOCOL = "AMQPWSB10";
    private static final String WEB_SOCKET_QUERY = "iothub-no-client-cert=true";
    private static final int MAX_MESSAGE_PAYLOAD_SIZE = 66560;
    private String connectionId;
    private final int keepAliveIntervalSeconds;
    protected final String hostName;
    private TokenCredential credential;
    private AzureSasCredential azureSasCredential;
    private String connectionString;
    private IotHubServiceClientProtocol protocol;
    private ProxyOptions proxyOptions;
    private SSLContext sslContext;
    Connection connection;
    private CbsSessionHandler cbsSessionHandler;
    private Runnable onConnectionClosedCallback;

    AmqpConnectionHandler(String connectionString, IotHubServiceClientProtocol protocol, Consumer<ErrorContext> errorProcessor, ProxyOptions proxyOptions, SSLContext sslContext, int keepAliveIntervalSeconds) {
        if (connectionString == null || connectionString.isEmpty()) {
            throw new IllegalArgumentException("connectionString can not be null or empty");
        }
        Objects.requireNonNull(protocol);
        this.proxyOptions = proxyOptions;
        this.hostName = IotHubConnectionStringBuilder.createIotHubConnectionString(connectionString).getHostName();
        this.connectionString = connectionString;
        this.errorProcessor = errorProcessor;
        this.keepAliveIntervalSeconds = keepAliveIntervalSeconds;
        this.commonConstructorSetup(protocol, proxyOptions, sslContext, keepAliveIntervalSeconds);
    }

    AmqpConnectionHandler(String hostName, AzureSasCredential azureSasCredential, IotHubServiceClientProtocol protocol, Consumer<ErrorContext> errorProcessor, ProxyOptions proxyOptions, SSLContext sslContext, int keepAliveIntervalSeconds) {
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName can not be null or empty");
        }
        Objects.requireNonNull(protocol);
        Objects.requireNonNull(azureSasCredential);
        this.hostName = hostName;
        this.azureSasCredential = azureSasCredential;
        this.errorProcessor = errorProcessor;
        this.keepAliveIntervalSeconds = keepAliveIntervalSeconds;
        this.commonConstructorSetup(protocol, proxyOptions, sslContext, keepAliveIntervalSeconds);
    }

    AmqpConnectionHandler(String hostName, TokenCredential credential, IotHubServiceClientProtocol protocol, Consumer<ErrorContext> errorProcessor, ProxyOptions proxyOptions, SSLContext sslContext, int keepAliveIntervalSeconds) {
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName can not be null or empty");
        }
        Objects.requireNonNull(protocol);
        Objects.requireNonNull(credential);
        this.hostName = hostName;
        this.credential = credential;
        this.errorProcessor = errorProcessor;
        this.keepAliveIntervalSeconds = keepAliveIntervalSeconds;
        this.commonConstructorSetup(protocol, proxyOptions, sslContext, keepAliveIntervalSeconds);
    }

    private void commonConstructorSetup(IotHubServiceClientProtocol protocol, ProxyOptions proxyOptions, SSLContext sslContext, int keepAliveIntervalSeconds) {
        this.proxyOptions = proxyOptions;
        this.sslContext = sslContext;
        this.protocol = protocol;
        this.connectionId = UUID.randomUUID().toString();
        if (keepAliveIntervalSeconds <= 0) {
            throw new IllegalArgumentException("Keep alive interval must be greater than 0 milliseconds");
        }
        if (proxyOptions != null && this.protocol != IotHubServiceClientProtocol.AMQPS_WS) {
            throw new UnsupportedOperationException("Proxies are only supported over AMQPS_WS");
        }
        this.add((Handler)new Handshaker());
    }

    public void onReactorInit(Event event) {
        Reactor reactor = event.getReactor();
        if (this.protocol == IotHubServiceClientProtocol.AMQPS_WS) {
            if (this.proxyOptions != null) {
                reactor.connectionToHost(this.proxyOptions.getHostName(), this.proxyOptions.getPort(), (Handler)this);
            } else {
                reactor.connectionToHost(this.hostName, 443, (Handler)this);
            }
        } else {
            reactor.connectionToHost(this.hostName, 5671, (Handler)this);
        }
    }

    public void onConnectionBound(Event event) {
        Transport transport = event.getConnection().getTransport();
        transport.setIdleTimeout(this.keepAliveIntervalSeconds * 1000);
        if (this.protocol == IotHubServiceClientProtocol.AMQPS_WS) {
            WebSocketImpl webSocket = new WebSocketImpl(66560);
            webSocket.configure(this.hostName, WEB_SOCKET_PATH, WEB_SOCKET_QUERY, 443, WEB_SOCKET_SUB_PROTOCOL, null, null);
            ((TransportInternal)transport).addTransportLayer((TransportLayer)webSocket);
        }
        transport.sasl().setMechanisms(new String[]{"ANONYMOUS"});
        SslDomain domain = this.makeDomain();
        domain.setPeerAuthentication(SslDomain.VerifyMode.VERIFY_PEER);
        transport.ssl(domain);
        if (this.proxyOptions != null) {
            this.addProxyLayer(transport, this.hostName);
        }
    }

    public void onConnectionInit(Event event) {
        Connection conn = event.getConnection();
        conn.setHostname(this.hostName);
        log.debug("Opening AMQP connection");
        conn.open();
    }

    @Override
    public void onLinkRemoteOpen(Event event) {
        super.onLinkRemoteOpen(event);
    }

    @Override
    public void onSessionRemoteOpen(Event event) {
        super.onSessionRemoteOpen(event);
    }

    @Override
    public void onConnectionRemoteOpen(Event event) {
        super.onConnectionRemoteOpen(event);
        this.connection = event.getConnection();
        Session cbsSession = event.getConnection().session();
        this.cbsSessionHandler = this.credential != null ? new CbsSessionHandler(cbsSession, (CbsSessionStateCallback)this, this.credential) : (this.azureSasCredential != null ? new CbsSessionHandler(cbsSession, (CbsSessionStateCallback)this, this.azureSasCredential) : new CbsSessionHandler(cbsSession, (CbsSessionStateCallback)this, this.connectionString));
    }

    @Override
    public void onConnectionRemoteClose(Event event) {
        super.onConnectionRemoteClose(event);
        if (this.onConnectionClosedCallback != null) {
            this.onConnectionClosedCallback.run();
        }
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void verifyConnectionWasOpened() throws IOException, IotHubException {
        if (this.protonJExceptionParser != null) {
            if (this.protonJExceptionParser.getIotHubException() != null) {
                throw this.protonJExceptionParser.getIotHubException();
            }
            if (this.protonJExceptionParser.getNetworkException() != null) {
                throw this.protonJExceptionParser.getNetworkException();
            }
        }
    }

    private SslDomain makeDomain() {
        SslDomain domain = Proton.sslDomain();
        if (this.sslContext == null) {
            domain.setSslContext(new IotHubSSLContext().getSSLContext());
        } else {
            domain.setSslContext(this.sslContext);
        }
        domain.init(SslDomain.Mode.CLIENT);
        return domain;
    }

    private void addProxyLayer(Transport transport, String hostName) {
        log.trace("Adding proxy layer to amqp_ws connection");
        ProxyImpl proxy = new ProxyImpl();
        ProxyHandlerImpl proxyHandler = new ProxyHandlerImpl();
        proxy.configure(hostName + ":" + 443, null, (ProxyHandler)proxyHandler, transport);
        ((TransportInternal)transport).addTransportLayer((TransportLayer)proxy);
    }

    public boolean isOpen() {
        return this.connection != null && this.connection.getLocalState() == EndpointState.ACTIVE && this.connection.getRemoteState() == EndpointState.ACTIVE && this.cbsSessionHandler.isOpen();
    }

    public void closeAsync(Runnable onConnectionClosedCallback) {
        if (this.connection != null) {
            log.debug("Shutdown event occurred, closing amqp connection");
            this.connection.close();
        }
        if (this.cbsSessionHandler != null) {
            log.debug("Shutdown event occurred, closing cbs session");
            this.cbsSessionHandler.close();
        }
        this.onConnectionClosedCallback = onConnectionClosedCallback;
    }

    @Override
    public void onAuthenticationFailed(IotHubException e) {
        this.protonJExceptionParser = new ProtonJExceptionParser(e);
    }

    public String getHostName() {
        return this.hostName;
    }
}

