/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.amqps;

import com.microsoft.azure.sdk.iot.service.transport.amqps.AmqpsMessage;
import com.microsoft.azure.sdk.iot.service.transport.amqps.AuthenticationMessageCallback;
import com.microsoft.azure.sdk.iot.service.transport.amqps.LinkStateCallback;
import com.microsoft.azure.sdk.iot.service.transport.amqps.ReceiverLinkHandler;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CbsReceiverLinkHandler
extends ReceiverLinkHandler {
    private static final Logger log = LoggerFactory.getLogger(CbsReceiverLinkHandler.class);
    private static final String APPLICATION_PROPERTY_STATUS_CODE_TAG = "status-code";
    private static final String APPLICATION_PROPERTY_STATUS_DESCRIPTION_TAG = "status-description";
    private static final String RECEIVER_LINK_ENDPOINT_PATH = "$cbs";
    private static final String RECEIVER_LINK_TAG_PREFIX = "cbs-receiver";
    private static final String LINK_TYPE = "cbs";
    private UUID authenticationMessageCorrelationId;
    private final AuthenticationMessageCallback authenticationMessageCallback;

    CbsReceiverLinkHandler(Receiver receiver, AuthenticationMessageCallback authenticationMessageCallback, LinkStateCallback linkStateCallback) {
        super(receiver, UUID.randomUUID().toString(), linkStateCallback);
        this.receiverLinkTag = RECEIVER_LINK_TAG_PREFIX;
        this.receiverLinkAddress = RECEIVER_LINK_ENDPOINT_PATH;
        this.authenticationMessageCallback = authenticationMessageCallback;
    }

    void setAuthenticationMessageCorrelationId(UUID authenticationMessageCorrelationId) {
        this.authenticationMessageCorrelationId = authenticationMessageCorrelationId;
    }

    static String getCbsTag() {
        return RECEIVER_LINK_TAG_PREFIX;
    }

    @Override
    public String getLinkInstanceType() {
        return LINK_TYPE;
    }

    public void onDelivery(Event event) {
        Delivery delivery = event.getDelivery();
        log.trace("Received a message on the CBS receiver link");
        this.handleCBSResponseMessage();
        delivery.free();
    }

    private void handleCBSResponseMessage() {
        AmqpsMessage amqpsMessage = super.getMessageFromReceiverLink();
        if (amqpsMessage != null) {
            if (amqpsMessage.getApplicationProperties() != null && amqpsMessage.getProperties() != null) {
                Properties properties = amqpsMessage.getProperties();
                UUID correlationId = (UUID)properties.getCorrelationId();
                Map applicationProperties = amqpsMessage.getApplicationProperties().getValue();
                if (!this.authenticationMessageCorrelationId.equals(correlationId)) {
                    log.error("Received cbs authentication message with unexpected correlation id. Ignoring it...");
                    amqpsMessage.acknowledge((DeliveryState)Released.getInstance());
                    return;
                }
                for (Map.Entry entry : applicationProperties.entrySet()) {
                    String propertyKey = (String)entry.getKey();
                    if (!propertyKey.equals(APPLICATION_PROPERTY_STATUS_CODE_TAG) || !(entry.getValue() instanceof Integer)) continue;
                    int authenticationResponseCode = (Integer)entry.getValue();
                    String statusDescription = "";
                    if (applicationProperties.containsKey(APPLICATION_PROPERTY_STATUS_DESCRIPTION_TAG)) {
                        statusDescription = (String)applicationProperties.get(APPLICATION_PROPERTY_STATUS_DESCRIPTION_TAG);
                    }
                    DeliveryState ackType = this.authenticationMessageCallback.handleAuthenticationResponseMessage(authenticationResponseCode, statusDescription);
                    amqpsMessage.acknowledge(ackType);
                    return;
                }
            } else {
                log.warn("Could not handle authentication message because it had no application properties or system properties");
            }
        } else {
            log.warn("Failed to read the message on the CBS receiver link");
        }
        if (amqpsMessage != null) {
            amqpsMessage.acknowledge((DeliveryState)Released.getInstance());
        }
    }
}

