/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.amqps;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionStringBuilder;
import com.microsoft.azure.sdk.iot.service.auth.IotHubServiceSasToken;
import com.microsoft.azure.sdk.iot.service.auth.TokenCredentialCache;
import com.microsoft.azure.sdk.iot.service.transport.amqps.LinkStateCallback;
import com.microsoft.azure.sdk.iot.service.transport.amqps.SenderLinkHandler;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CbsSenderLinkHandler
extends SenderLinkHandler {
    private static final Logger log = LoggerFactory.getLogger(CbsSenderLinkHandler.class);
    private static final String SENDER_LINK_ENDPOINT_PATH = "$cbs";
    private static final String SENDER_LINK_TAG_PREFIX = "cbs-sender";
    private static final String CBS_TO = "$cbs";
    private static final String CBS_REPLY = "cbs";
    private static final String LINK_TYPE = "cbs";
    private static final String PUT_TOKEN_TYPE = "type";
    private static final String PUT_TOKEN_AUDIENCE = "name";
    private static final String PUT_TOKEN_EXPIRY = "expiration";
    private static final String PUT_TOKEN_OPERATION = "operation";
    private static final String PUT_TOKEN_OPERATION_VALUE = "put-token";
    private TokenCredential credential;
    private AccessToken currentAccessToken;
    private String connectionString;
    private AzureSasCredential sasTokenProvider;
    private static final String BEARER = "Bearer";
    private static final String SAS_TOKEN = "servicebus.windows.net:sastoken";
    private static final String EXPIRY_KEY = "se=";

    CbsSenderLinkHandler(Sender sender, LinkStateCallback linkStateCallback, TokenCredential credential) {
        super(sender, UUID.randomUUID().toString(), linkStateCallback);
        this.senderLinkTag = SENDER_LINK_TAG_PREFIX;
        this.senderLinkAddress = "$cbs";
        this.credential = credential;
    }

    CbsSenderLinkHandler(Sender sender, LinkStateCallback linkStateCallback, AzureSasCredential sasTokenProvider) {
        super(sender, UUID.randomUUID().toString(), linkStateCallback);
        this.senderLinkTag = SENDER_LINK_TAG_PREFIX;
        this.senderLinkAddress = "$cbs";
        this.sasTokenProvider = sasTokenProvider;
    }

    CbsSenderLinkHandler(Sender sender, LinkStateCallback linkStateCallback, String connectionString) {
        super(sender, UUID.randomUUID().toString(), linkStateCallback);
        this.senderLinkTag = SENDER_LINK_TAG_PREFIX;
        this.senderLinkAddress = "$cbs";
        this.connectionString = connectionString;
    }

    static String getCbsTag() {
        return SENDER_LINK_TAG_PREFIX;
    }

    @Override
    public String getLinkInstanceType() {
        return "cbs";
    }

    public int sendAuthenticationMessage(UUID authenticationMessageCorrelationId) {
        MessageImpl outgoingMessage = (MessageImpl)Proton.message();
        Properties properties = new Properties();
        properties.setMessageId((Object)authenticationMessageCorrelationId);
        properties.setTo("$cbs");
        properties.setReplyTo("cbs");
        outgoingMessage.setProperties(properties);
        HashMap<String, Object> applicationProperties = new HashMap<String, Object>();
        applicationProperties.put(PUT_TOKEN_OPERATION, PUT_TOKEN_OPERATION_VALUE);
        if (this.credential != null) {
            TokenRequestContext context = new TokenRequestContext().addScopes(TokenCredentialCache.IOTHUB_PUBLIC_SCOPE);
            this.currentAccessToken = (AccessToken)this.credential.getToken(context).block();
            if (this.currentAccessToken == null) {
                log.error("The AccessToken supplied by the TokenCredential for the CbsSenderLinkHandler was null.");
                return -1;
            }
            applicationProperties.put(PUT_TOKEN_EXPIRY, Date.from(this.currentAccessToken.getExpiresAt().toInstant()));
            applicationProperties.put(PUT_TOKEN_TYPE, BEARER);
            AmqpValue section = new AmqpValue((Object)("Bearer " + this.currentAccessToken.getToken()));
            outgoingMessage.setBody((Section)section);
        } else if (this.sasTokenProvider != null) {
            String sasToken = this.sasTokenProvider.getSignature();
            this.currentAccessToken = this.getAccessTokenFromSasToken(sasToken);
            applicationProperties.put(PUT_TOKEN_TYPE, SAS_TOKEN);
            AmqpValue section = new AmqpValue((Object)sasToken);
            outgoingMessage.setBody((Section)section);
        } else {
            IotHubConnectionString iotHubConnectionString = IotHubConnectionStringBuilder.createIotHubConnectionString(this.connectionString);
            String sasToken = new IotHubServiceSasToken(iotHubConnectionString).toString();
            this.currentAccessToken = this.getAccessTokenFromSasToken(sasToken);
            applicationProperties.put(PUT_TOKEN_TYPE, SAS_TOKEN);
            AmqpValue section = new AmqpValue((Object)sasToken);
            outgoingMessage.setBody((Section)section);
        }
        applicationProperties.put(PUT_TOKEN_AUDIENCE, this.senderLink.getSession().getConnection().getHostname());
        outgoingMessage.setApplicationProperties(new ApplicationProperties(applicationProperties));
        return this.sendMessageAndGetDeliveryTag((Message)outgoingMessage);
    }

    private AccessToken getAccessTokenFromSasToken(String sasToken) {
        String[] signatureParts = sasToken.split(" ");
        if (signatureParts.length != 2) {
            RuntimeException runtimeException = new RuntimeException("failed to parse shared access signature, unable to get the signature's time to live");
            log.error("Failed to get token from AzureSasCredential", (Throwable)runtimeException);
            throw runtimeException;
        }
        String[] signatureKeyValuePairs = signatureParts[1].split("&");
        int expiryTimeSeconds = -1;
        for (String signatureKeyValuePair : signatureKeyValuePairs) {
            if (!signatureKeyValuePair.startsWith(EXPIRY_KEY)) continue;
            String expiryTimeValue = signatureKeyValuePair.substring(EXPIRY_KEY.length());
            try {
                expiryTimeSeconds = Integer.parseInt(expiryTimeValue);
            }
            catch (NumberFormatException e) {
                RuntimeException runtimeException = new RuntimeException("Failed to parse shared access signature, unable to parse the signature's time to live to an integer", e);
                log.error("Failed to get token from AzureSasCredential", (Throwable)runtimeException);
                throw runtimeException;
            }
        }
        if (expiryTimeSeconds == -1) {
            RuntimeException runtimeException = new RuntimeException("Failed to parse shared access signature, signature does not include key value pair for expiry time");
            log.error("Failed to get token from AzureSasCredential", (Throwable)runtimeException);
            throw runtimeException;
        }
        OffsetDateTime sasTokenExpiryOffsetDateTime = OffsetDateTime.ofInstant(Instant.ofEpochSecond(expiryTimeSeconds), ZoneId.systemDefault());
        return new AccessToken(sasToken, sasTokenExpiryOffsetDateTime);
    }

    public AccessToken getCurrentAccessToken() {
        return this.currentAccessToken;
    }
}

