/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.amqps;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.microsoft.azure.sdk.iot.service.ProxyOptions;
import com.microsoft.azure.sdk.iot.service.messaging.AcknowledgementType;
import com.microsoft.azure.sdk.iot.service.messaging.ErrorContext;
import com.microsoft.azure.sdk.iot.service.messaging.FeedbackBatch;
import com.microsoft.azure.sdk.iot.service.messaging.FileUploadNotification;
import com.microsoft.azure.sdk.iot.service.messaging.IotHubServiceClientProtocol;
import com.microsoft.azure.sdk.iot.service.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.service.transport.amqps.AmqpConnectionHandler;
import com.microsoft.azure.sdk.iot.service.transport.amqps.FileUploadNotificationReceiverLinkHandler;
import com.microsoft.azure.sdk.iot.service.transport.amqps.LinkStateCallback;
import com.microsoft.azure.sdk.iot.service.transport.amqps.MessageFeedbackReceiverLinkHandler;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventReceivingConnectionHandler
extends AmqpConnectionHandler
implements LinkStateCallback {
    private static final Logger log = LoggerFactory.getLogger(EventReceivingConnectionHandler.class);
    private static final String FILE_NOTIFICATION_RECEIVE_TAG = "fileUploadNotificationReceiver";
    private static final String FILENOTIFICATION_ENDPOINT = "/messages/serviceBound/filenotifications";
    public static final String MESSAGE_FEEDBACK_RECEIVE_TAG = "cloudToDeviceMessageFeedbackReceiver";
    private static final String MESSAGE_FEEDBACK_ENDPOINT = "/messages/servicebound/feedback";
    private FileUploadNotificationReceiverLinkHandler fileUploadNotificationReceiverLinkHandler;
    private MessageFeedbackReceiverLinkHandler messageFeedbackReceiverLinkHandler;
    private Session session;
    private Runnable onConnectionOpenedCallback;
    private final Function<FileUploadNotification, AcknowledgementType> fileUploadNotificationReceivedCallback;
    private final Function<FeedbackBatch, AcknowledgementType> messageFeedbackReceivedCallback;

    public EventReceivingConnectionHandler(String connectionString, IotHubServiceClientProtocol protocol, Function<FileUploadNotification, AcknowledgementType> fileUploadNotificationReceivedCallback, Function<FeedbackBatch, AcknowledgementType> messageFeedbackReceivedCallback, Consumer<ErrorContext> errorProcessor, ProxyOptions proxyOptions, SSLContext sslContext, int keepAliveIntervalSeconds) {
        super(connectionString, protocol, errorProcessor, proxyOptions, sslContext, keepAliveIntervalSeconds);
        this.fileUploadNotificationReceivedCallback = fileUploadNotificationReceivedCallback;
        this.messageFeedbackReceivedCallback = messageFeedbackReceivedCallback;
    }

    public EventReceivingConnectionHandler(String hostName, TokenCredential credential, IotHubServiceClientProtocol protocol, Function<FileUploadNotification, AcknowledgementType> fileUploadNotificationReceivedCallback, Function<FeedbackBatch, AcknowledgementType> messageFeedbackReceivedCallback, Consumer<ErrorContext> errorProcessor, ProxyOptions proxyOptions, SSLContext sslContext, int keepAliveIntervalSeconds) {
        super(hostName, credential, protocol, errorProcessor, proxyOptions, sslContext, keepAliveIntervalSeconds);
        this.fileUploadNotificationReceivedCallback = fileUploadNotificationReceivedCallback;
        this.messageFeedbackReceivedCallback = messageFeedbackReceivedCallback;
    }

    public EventReceivingConnectionHandler(String hostName, AzureSasCredential azureSasCredential, IotHubServiceClientProtocol protocol, Function<FileUploadNotification, AcknowledgementType> fileUploadNotificationReceivedCallback, Function<FeedbackBatch, AcknowledgementType> messageFeedbackReceivedCallback, Consumer<ErrorContext> errorProcessor, ProxyOptions proxyOptions, SSLContext sslContext, int keepAliveIntervalSeconds) {
        super(hostName, azureSasCredential, protocol, errorProcessor, proxyOptions, sslContext, keepAliveIntervalSeconds);
        this.fileUploadNotificationReceivedCallback = fileUploadNotificationReceivedCallback;
        this.messageFeedbackReceivedCallback = messageFeedbackReceivedCallback;
    }

    @Override
    public void onAuthenticationSucceeded() {
        if (this.fileUploadNotificationReceiverLinkHandler == null) {
            Source source;
            this.session = this.connection.session();
            this.session.open();
            HashMap<Symbol, String> properties = new HashMap<Symbol, String>();
            properties.put(Symbol.getSymbol((String)"com.microsoft:client-version"), TransportUtils.USER_AGENT_STRING);
            if (this.fileUploadNotificationReceivedCallback != null) {
                Receiver fileUploadNotificationReceiverLink = this.session.receiver(FILE_NOTIFICATION_RECEIVE_TAG);
                fileUploadNotificationReceiverLink.setProperties(properties);
                fileUploadNotificationReceiverLink.open();
                source = new Source();
                source.setAddress(FILENOTIFICATION_ENDPOINT);
                fileUploadNotificationReceiverLink.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
                fileUploadNotificationReceiverLink.flow(1);
                this.fileUploadNotificationReceiverLinkHandler = new FileUploadNotificationReceiverLinkHandler(fileUploadNotificationReceiverLink, this, this.fileUploadNotificationReceivedCallback);
            }
            if (this.messageFeedbackReceivedCallback != null) {
                Receiver feedbackReceiverLink = this.session.receiver(MESSAGE_FEEDBACK_RECEIVE_TAG);
                feedbackReceiverLink.setProperties(properties);
                log.debug("Opening connection, session and link for amqp feedback receiver");
                feedbackReceiverLink.open();
                source = new Source();
                source.setAddress(MESSAGE_FEEDBACK_ENDPOINT);
                feedbackReceiverLink.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
                feedbackReceiverLink.flow(1);
                this.messageFeedbackReceiverLinkHandler = new MessageFeedbackReceiverLinkHandler(feedbackReceiverLink, this, this.messageFeedbackReceivedCallback);
            }
        }
    }

    @Override
    public void onSenderLinkRemoteOpen() {
    }

    @Override
    public void onReceiverLinkRemoteOpen() {
        if (this.onConnectionOpenedCallback != null) {
            this.onConnectionOpenedCallback.run();
        }
    }

    @Override
    public void closeAsync(Runnable onConnectionClosedCallback) {
        if (this.session != null) {
            log.debug("Shutdown event occurred, closing session");
            this.session.close();
        }
        if (this.fileUploadNotificationReceiverLinkHandler != null) {
            log.debug("Shutdown event occurred, closing file upload notification receiver link");
            this.fileUploadNotificationReceiverLinkHandler.close();
        }
        if (this.messageFeedbackReceiverLinkHandler != null) {
            log.debug("Shutdown event occurred, closing cloud to device feedback message receiver link");
            this.messageFeedbackReceiverLinkHandler.close();
        }
        super.closeAsync(onConnectionClosedCallback);
    }

    public void onReactorFinal(Event event) {
        this.messageFeedbackReceiverLinkHandler = null;
        this.fileUploadNotificationReceiverLinkHandler = null;
    }

    public void setOnConnectionOpenedCallback(Runnable onConnectionOpenedCallback) {
        this.onConnectionOpenedCallback = onConnectionOpenedCallback;
    }
}

