/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.amqps;

import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFlowController
extends BaseHandler {
    private static final Logger log = LoggerFactory.getLogger(LoggingFlowController.class);
    private static final int WINDOW = 1024;
    private final String linkCorrelationId;

    public LoggingFlowController(String linkCorrelationId) {
        this.linkCorrelationId = linkCorrelationId;
    }

    private void topup(Receiver link) {
        int delta = 1024 - link.getCredit();
        if (delta > 0) {
            log.trace("Flowing {} credit(s) back to service on receiver link with address {} and correlation id {}", new Object[]{delta, link.getSource().getAddress(), this.linkCorrelationId});
            link.flow(delta);
        }
    }

    public void onUnhandled(Event event) {
        Link link = event.getLink();
        switch (event.getType()) {
            case LINK_LOCAL_OPEN: 
            case LINK_REMOTE_OPEN: 
            case LINK_FLOW: 
            case DELIVERY: {
                if (!(link instanceof Receiver)) break;
                this.topup((Receiver)link);
                break;
            }
        }
    }
}

