/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.amqps;

import com.microsoft.azure.sdk.iot.service.exceptions.IotHubDeviceMaximumQueueDepthExceededException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubInternalServerErrorException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubInvalidOperationException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubMessageTooLargeException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubNotFoundException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubNotSupportedException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubPreconditionFailedException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubUnauthorizedException;
import java.io.IOException;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Endpoint;
import org.apache.qpid.proton.engine.Event;

public class ProtonJExceptionParser {
    private String error;
    private String errorDescription;
    private final IotHubException iotHubException;
    private final IOException networkException;
    private static final String DEFAULT_ERROR_DESCRIPTION = "NoErrorDescription";

    public ProtonJExceptionParser(Event event) {
        this.getErrorFromEndpoints(new Endpoint[]{event.getSender(), event.getReceiver(), event.getConnection(), event.getTransport(), event.getSession(), event.getLink()});
        this.iotHubException = ProtonJExceptionParser.getIotHubException(this.error, this.errorDescription);
        this.networkException = ProtonJExceptionParser.getNetworkException(this.error, this.errorDescription);
    }

    public ProtonJExceptionParser(String error, String errorDescription) {
        this.error = error;
        this.errorDescription = errorDescription;
        this.iotHubException = ProtonJExceptionParser.getIotHubException(this.error, this.errorDescription);
        this.networkException = ProtonJExceptionParser.getNetworkException(this.error, this.errorDescription);
    }

    public ProtonJExceptionParser(IotHubException iotHubException) {
        this.iotHubException = iotHubException;
        this.networkException = null;
    }

    private static IotHubException getIotHubException(String error, String errorDescription) {
        switch (error) {
            case "amqp:unauthorized-access": {
                return new IotHubUnauthorizedException(errorDescription);
            }
            case "amqp:not-found": {
                return new IotHubNotFoundException(errorDescription);
            }
            case "amqp:resource-limit-exceeded": {
                return new IotHubDeviceMaximumQueueDepthExceededException(errorDescription);
            }
            case "amqp:link:message-size-exceeded": {
                return new IotHubMessageTooLargeException(errorDescription);
            }
            case "amqp:internal-error": {
                return new IotHubInternalServerErrorException(errorDescription);
            }
            case "amqp:not-allowed": {
                return new IotHubInvalidOperationException(errorDescription);
            }
            case "amqp:not-implemented": {
                return new IotHubNotSupportedException(errorDescription);
            }
            case "amqp:precondition-failed": {
                return new IotHubPreconditionFailedException(errorDescription);
            }
        }
        if (ProtonJExceptionParser.getNetworkException(error, errorDescription) == null) {
            return new IotHubException(error + ":" + errorDescription);
        }
        return null;
    }

    private static IOException getNetworkException(String error, String errorDescription) {
        if (error.equals("proton:io")) {
            return new IOException(errorDescription);
        }
        return null;
    }

    private ErrorCondition getErrorConditionFromEndpoint(Endpoint endpoint) {
        return endpoint.getCondition() != null && endpoint.getCondition().getCondition() != null ? endpoint.getCondition() : endpoint.getRemoteCondition();
    }

    private void getErrorFromEndpoints(Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            ErrorCondition errorCondition;
            if (endpoint == null || (errorCondition = this.getErrorConditionFromEndpoint(endpoint)) == null || errorCondition.getCondition() == null) continue;
            this.error = errorCondition.getCondition().toString();
            this.errorDescription = errorCondition.getDescription() != null ? errorCondition.getDescription() : DEFAULT_ERROR_DESCRIPTION;
        }
    }

    public String getError() {
        return this.error;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public IotHubException getIotHubException() {
        return this.iotHubException;
    }

    public IOException getNetworkException() {
        return this.networkException;
    }
}

