/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.amqps;

import com.microsoft.azure.sdk.iot.service.transport.amqps.AmqpConnectionHandler;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.HandlerException;
import org.apache.qpid.proton.reactor.Reactor;
import org.apache.qpid.proton.reactor.ReactorOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactorRunner {
    private static final Logger log = LoggerFactory.getLogger(ReactorRunner.class);
    private static final String THREAD_NAME = "azure-iot-sdk-ReactorRunner";
    private final String threadName;
    private final Reactor reactor;
    private static final int REACTOR_TIMEOUT = 3141;
    private static final int MAX_FRAME_SIZE = 4096;
    private final AmqpConnectionHandler handler;

    public ReactorRunner(AmqpConnectionHandler handler) throws IOException {
        this(null, null, handler);
    }

    public ReactorRunner(String threadNamePrefix, String threadNamePostfix, AmqpConnectionHandler handler) throws IOException {
        ReactorOptions options = new ReactorOptions();
        options.setMaxFrameSize(4096);
        this.reactor = Proton.reactor((ReactorOptions)options, (Handler[])new Handler[]{handler});
        this.threadName = threadNamePrefix + "-" + THREAD_NAME + "-" + threadNamePostfix;
        this.handler = handler;
    }

    public void run() {
        if (this.threadName != null) {
            Thread.currentThread().setName(this.threadName);
        }
        try {
            log.trace("Starting reactor thread {}", (Object)this.threadName);
            this.reactor.setTimeout(3141L);
            this.reactor.run();
        }
        catch (HandlerException e) {
            log.debug("Encountered an exception while running reactor on thread {}", (Object)this.threadName, (Object)e);
        }
        finally {
            log.trace("Freeing reactor now that reactor thread is done");
            this.reactor.free();
        }
        log.trace("Finished reactor thread {}", (Object)this.threadName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int timeoutMilliseconds) throws InterruptedException {
        if (timeoutMilliseconds < 0) {
            throw new IllegalArgumentException("timeoutMilliseconds must greater than or equal to 0");
        }
        try {
            CountDownLatch onReactorClosedLatch = new CountDownLatch(1);
            this.handler.closeAsync(() -> onReactorClosedLatch.countDown());
            if (timeoutMilliseconds > 0) {
                boolean timedOut;
                boolean bl = timedOut = !onReactorClosedLatch.await(timeoutMilliseconds, TimeUnit.MILLISECONDS);
                if (timedOut) {
                    log.debug("Timed out waiting for amqp connection to close gracefully. Closing forcefully now.");
                }
            } else {
                onReactorClosedLatch.await();
            }
        }
        finally {
            this.reactor.stop();
        }
    }

    public boolean isRunning() {
        return this.reactor != null && this.handler != null && this.handler.isOpen();
    }
}

