/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.http;

import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubExceptionManager;
import com.microsoft.azure.sdk.iot.service.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpMethod;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class HttpRequest {
    private static final String USER_AGENT = "User-Agent";
    private static final String ACCEPT = "Accept";
    private static final String ACCEPT_VALUE = "application/json";
    private static final String ACCEPT_CHARSET = "charset=utf-8";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String AUTHORIZATION = "Authorization";
    public static final String REQUEST_ID = "Request-Id";
    public static final String IF_MATCH = "If-Match";
    private final HttpsURLConnection connection;
    private byte[] body;

    public HttpRequest(URL url, HttpMethod method, byte[] body, String authorizationToken) throws IOException {
        this(url, method, body, authorizationToken, null);
    }

    public HttpRequest(URL url, HttpMethod method, byte[] body, String authorizationToken, Proxy proxy) throws IOException {
        this.connection = proxy != null ? (HttpsURLConnection)url.openConnection(proxy) : (HttpsURLConnection)url.openConnection();
        if (method != HttpMethod.POST && method != HttpMethod.PUT && method != HttpMethod.PATCH) {
            if (body.length > 0) {
                throw new IllegalArgumentException("Cannot write a body to a request that is not a POST, PATCH or PUT request.");
            }
        } else {
            this.body = Arrays.copyOf(body, body.length);
        }
        if (method == HttpMethod.PATCH) {
            this.setHeaderField("X-HTTP-Method-Override", "PATCH");
            this.connection.setRequestMethod("POST");
        } else {
            this.connection.setRequestMethod(method.name());
        }
        this.setHeaderField(USER_AGENT, TransportUtils.USER_AGENT_STRING);
        this.setHeaderField(ACCEPT, ACCEPT_VALUE);
        this.setHeaderField(CONTENT_TYPE, "application/json; charset=utf-8");
        this.setHeaderField(AUTHORIZATION, authorizationToken);
        this.setHeaderField(CONTENT_LENGTH, String.valueOf(body.length));
    }

    public HttpResponse send() throws IotHubException, IOException {
        Map<String, List<String>> headerFields;
        int responseStatus;
        byte[] responseBody = new byte[]{};
        byte[] errorReason = new byte[]{};
        try {
            if (this.body != null && this.body.length > 0) {
                this.connection.setDoOutput(true);
                this.connection.getOutputStream().write(this.body);
            }
            this.connection.connect();
            responseStatus = this.connection.getResponseCode();
            headerFields = this.connection.getHeaderFields();
            try (InputStream inputStream = this.connection.getInputStream();){
                responseBody = HttpRequest.readInputStream(inputStream);
            }
        }
        catch (IOException e) {
            responseStatus = this.connection.getResponseCode();
            headerFields = this.connection.getHeaderFields();
            try (InputStream errorStream = this.connection.getErrorStream();){
                if (errorStream != null) {
                    errorReason = HttpRequest.readInputStream(errorStream);
                }
            }
        }
        HttpResponse response = new HttpResponse(responseStatus, responseBody, headerFields, errorReason);
        IotHubExceptionManager.httpResponseVerification(response);
        return response;
    }

    public HttpRequest setHeaderField(String field, String value) {
        this.connection.setRequestProperty(field, value);
        return this;
    }

    public HttpRequest setHeaders(Map<String, String> headers) {
        if (headers == null) {
            return this;
        }
        for (String header : headers.keySet()) {
            this.connection.setRequestProperty(header, headers.get(header));
        }
        return this;
    }

    public HttpRequest setReadTimeoutSeconds(int timeout) {
        int readTimeoutMillis = timeout * 1000;
        this.connection.setReadTimeout(readTimeoutMillis);
        return this;
    }

    public HttpRequest setConnectTimeoutSeconds(int timeout) {
        int connectTimeoutMillis = timeout * 1000;
        this.connection.setConnectTimeout(connectTimeoutMillis);
        return this;
    }

    protected HttpRequest() {
        this.connection = null;
    }

    private static byte[] readInputStream(InputStream stream) throws IOException {
        int nextByte;
        ArrayList<Byte> byteBuffer = new ArrayList<Byte>();
        while ((nextByte = stream.read()) > -1) {
            byteBuffer.add((byte)nextByte);
        }
        int bufferSize = byteBuffer.size();
        byte[] byteArray = new byte[bufferSize];
        for (int i = 0; i < bufferSize; ++i) {
            byteArray[i] = (Byte)byteBuffer.get(i);
        }
        return byteArray;
    }
}

