/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.twin;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionStringBuilder;
import com.microsoft.azure.sdk.iot.service.auth.IotHubServiceSasToken;
import com.microsoft.azure.sdk.iot.service.auth.TokenCredentialCache;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.query.QueryClient;
import com.microsoft.azure.sdk.iot.service.query.QueryClientOptions;
import com.microsoft.azure.sdk.iot.service.query.QueryPageOptions;
import com.microsoft.azure.sdk.iot.service.query.TwinQueryResponse;
import com.microsoft.azure.sdk.iot.service.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpMethod;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpRequest;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpResponse;
import com.microsoft.azure.sdk.iot.service.twin.Twin;
import com.microsoft.azure.sdk.iot.service.twin.TwinClientOptions;
import com.microsoft.azure.sdk.iot.service.twin.TwinState;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TwinClient {
    private static final Logger log = LoggerFactory.getLogger(TwinClient.class);
    private int requestId = 0;
    private final TwinClientOptions options;
    private final String hostName;
    private TokenCredentialCache credentialCache;
    private AzureSasCredential azureSasCredential;
    private IotHubConnectionString iotHubConnectionString;
    private final QueryClient queryClient;

    public TwinClient(String connectionString) {
        this(connectionString, TwinClientOptions.builder().build());
    }

    public TwinClient(String connectionString, TwinClientOptions options) {
        if (connectionString == null || connectionString.isEmpty()) {
            throw new IllegalArgumentException("connectionString cannot be null or empty.");
        }
        this.options = options;
        this.iotHubConnectionString = IotHubConnectionStringBuilder.createIotHubConnectionString(connectionString);
        this.hostName = this.iotHubConnectionString.getHostName();
        TwinClient.commonConstructorSetup();
        QueryClientOptions queryClientOptions = QueryClientOptions.builder().httpReadTimeoutSeconds(options.getHttpReadTimeoutSeconds()).httpConnectTimeoutSeconds(options.getHttpConnectTimeoutSeconds()).proxyOptions(options.getProxyOptions()).build();
        this.queryClient = new QueryClient(connectionString, queryClientOptions);
    }

    public TwinClient(String hostName, TokenCredential credential) {
        this(hostName, credential, TwinClientOptions.builder().build());
    }

    public TwinClient(String hostName, TokenCredential credential, TwinClientOptions options) {
        Objects.requireNonNull(credential, "TokenCredential cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        this.options = options;
        this.credentialCache = new TokenCredentialCache(credential);
        this.hostName = hostName;
        TwinClient.commonConstructorSetup();
        QueryClientOptions queryClientOptions = QueryClientOptions.builder().httpReadTimeoutSeconds(options.getHttpReadTimeoutSeconds()).httpConnectTimeoutSeconds(options.getHttpConnectTimeoutSeconds()).proxyOptions(options.getProxyOptions()).build();
        this.queryClient = new QueryClient(hostName, credential, queryClientOptions);
    }

    public TwinClient(String hostName, AzureSasCredential azureSasCredential) {
        this(hostName, azureSasCredential, TwinClientOptions.builder().build());
    }

    public TwinClient(String hostName, AzureSasCredential azureSasCredential, TwinClientOptions options) {
        Objects.requireNonNull(azureSasCredential, "azureSasCredential cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        this.options = options;
        this.azureSasCredential = azureSasCredential;
        this.hostName = hostName;
        TwinClient.commonConstructorSetup();
        QueryClientOptions queryClientOptions = QueryClientOptions.builder().httpReadTimeoutSeconds(options.getHttpReadTimeoutSeconds()).httpConnectTimeoutSeconds(options.getHttpConnectTimeoutSeconds()).proxyOptions(options.getProxyOptions()).build();
        this.queryClient = new QueryClient(hostName, azureSasCredential, queryClientOptions);
    }

    private static void commonConstructorSetup() {
        log.debug("Initialized a TwinClient instance using SDK version {}", (Object)TransportUtils.serviceVersion);
    }

    public Twin get(String deviceId) throws IotHubException, IOException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("DeviceId must not be null or empty");
        }
        return this.get(IotHubConnectionString.getUrlTwin(this.hostName, deviceId));
    }

    public Twin get(String deviceId, String moduleId) throws IotHubException, IOException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("DeviceId must not be null or empty");
        }
        return this.get(IotHubConnectionString.getUrlModuleTwin(this.hostName, deviceId, moduleId));
    }

    private Twin get(URL url) throws IotHubException, IOException {
        HttpRequest httpRequest = this.createRequest(url, HttpMethod.GET, new byte[0]);
        HttpResponse response = httpRequest.send();
        String twinString = new String(response.getBody(), StandardCharsets.UTF_8);
        return Twin.fromJson(twinString);
    }

    public Twin patch(Twin twin) throws IotHubException, IOException {
        return this.patch(twin, null);
    }

    public Twin patch(Twin twin, String ifMatch) throws IotHubException, IOException {
        if (twin == null || twin.getDeviceId() == null || twin.getDeviceId().length() == 0) {
            throw new IllegalArgumentException("Instantiate a twin and set device Id to be used.");
        }
        if ((twin.getDesiredProperties() == null || twin.getDesiredProperties().isEmpty()) && (twin.getTags() == null || twin.getTags().isEmpty())) {
            throw new IllegalArgumentException("Set either desired properties or tags for the device to be updated.");
        }
        URL url = twin.getModuleId() == null || twin.getModuleId().length() == 0 ? IotHubConnectionString.getUrlTwin(this.hostName, twin.getDeviceId()) : IotHubConnectionString.getUrlModuleTwin(this.hostName, twin.getDeviceId(), twin.getModuleId());
        TwinState twinState = new TwinState(twin.getTags(), twin.getDesiredProperties(), null);
        String twinJson = twinState.toJsonElement().toString();
        HttpRequest httpRequest = this.createRequest(url, HttpMethod.PATCH, twinJson.getBytes(StandardCharsets.UTF_8));
        if (ifMatch != null) {
            httpRequest.setHeaderField("If-Match", ifMatch);
        }
        HttpResponse httpResponse = httpRequest.send();
        String twinString = new String(httpResponse.getBody(), StandardCharsets.UTF_8);
        return Twin.fromJson(twinString);
    }

    public Twin replace(Twin twin) throws IotHubException, IOException {
        return this.replace(twin, null);
    }

    public Twin replace(Twin twin, String ifMatch) throws IotHubException, IOException {
        if (twin == null || twin.getDeviceId() == null || twin.getDeviceId().length() == 0) {
            throw new IllegalArgumentException("Instantiate a device and set device Id to be used.");
        }
        URL url = twin.getModuleId() == null || twin.getModuleId().length() == 0 ? this.iotHubConnectionString.getUrlTwin(twin.getDeviceId()) : this.iotHubConnectionString.getUrlModuleTwin(twin.getDeviceId(), twin.getModuleId());
        TwinState twinState = new TwinState(twin.getTags(), twin.getDesiredProperties(), null);
        String twinJson = twinState.toJsonElement().toString();
        HttpRequest httpRequest = this.createRequest(url, HttpMethod.PUT, twinJson.getBytes(StandardCharsets.UTF_8));
        if (ifMatch != null) {
            httpRequest.setHeaderField("If-Match", ifMatch);
        }
        HttpResponse httpResponse = httpRequest.send();
        String twinString = new String(httpResponse.getBody(), StandardCharsets.UTF_8);
        return Twin.fromJson(twinString);
    }

    public TwinQueryResponse query(String query) throws IOException, IotHubException {
        return this.queryClient.queryTwins(query);
    }

    public TwinQueryResponse query(String query, QueryPageOptions options) throws IOException, IotHubException {
        return this.queryClient.queryTwins(query, options);
    }

    private HttpRequest createRequest(URL url, HttpMethod method, byte[] payload) throws IOException {
        Proxy proxy = null;
        if (this.options.getProxyOptions() != null) {
            proxy = this.options.getProxyOptions().getProxy();
        }
        HttpRequest request = new HttpRequest(url, method, payload, this.getAuthenticationToken(), proxy);
        request.setReadTimeoutSeconds(this.options.getHttpReadTimeoutSeconds());
        request.setConnectTimeoutSeconds(this.options.getHttpConnectTimeoutSeconds());
        request.setHeaderField("Request-Id", String.valueOf(this.requestId++));
        return request;
    }

    private String getAuthenticationToken() {
        if (this.credentialCache != null) {
            return this.credentialCache.getTokenString();
        }
        if (this.azureSasCredential != null) {
            return this.azureSasCredential.getSignature();
        }
        return new IotHubServiceSasToken(this.iotHubConnectionString).toString();
    }
}

