/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.twin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.azure.sdk.iot.service.ParserUtility;
import com.microsoft.azure.sdk.iot.service.twin.Tools;
import com.microsoft.azure.sdk.iot.service.twin.TwinMetadata;
import java.util.HashMap;
import java.util.Map;

public class TwinCollection
extends HashMap<String, Object> {
    private static final String VERSION_TAG = "$version";
    private Integer version;
    private static final String METADATA_TAG = "$metadata";
    private TwinMetadata twinMetadata;
    private final Map<String, TwinMetadata> metadataMap = new HashMap<String, TwinMetadata>();

    public TwinCollection() {
    }

    public TwinCollection(Map<? extends String, Object> map) {
        if (map != null && !map.isEmpty()) {
            this.putAll(map);
        }
    }

    public TwinCollection(TwinCollection collection) {
        if (collection != null && !collection.isEmpty()) {
            this.version = collection.getVersion();
            this.twinMetadata = collection.getTwinMetadata();
            for (Map.Entry entry : collection.entrySet()) {
                if (entry.getValue() instanceof TwinCollection) {
                    super.put(entry.getKey(), new TwinCollection((TwinCollection)entry.getValue()));
                } else {
                    super.put(entry.getKey(), entry.getValue());
                }
                this.metadataMap.put((String)entry.getKey(), collection.getTwinMetadata((String)entry.getKey()));
            }
        }
    }

    final Map<String, TwinMetadata> getMetadataMap() {
        return this.metadataMap;
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("map to add cannot be null or empty.");
        }
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
        Object last = this.get(key);
        if (value instanceof Map) {
            super.put(key, new TwinCollection((Map)value));
        } else {
            super.put(key, value);
        }
        if (!key.equals(VERSION_TAG) && !key.equals(METADATA_TAG)) {
            ParserUtility.validateMap(this);
        }
        return last;
    }

    static TwinCollection createFromRawCollection(Map<? extends String, Object> rawCollection) {
        TwinCollection twinCollection = new TwinCollection();
        Map metadata = null;
        for (Map.Entry<? extends String, Object> entry : rawCollection.entrySet()) {
            if (entry.getKey().equals(VERSION_TAG)) {
                if (!(entry.getValue() instanceof Number)) {
                    throw new IllegalArgumentException("version is not a number");
                }
                twinCollection.version = ((Number)entry.getValue()).intValue();
                continue;
            }
            if (entry.getKey().equals(METADATA_TAG)) {
                metadata = (Map)entry.getValue();
                continue;
            }
            twinCollection.put(entry.getKey(), entry.getValue());
        }
        if (metadata != null) {
            TwinCollection.addMetadata(twinCollection, metadata);
        }
        return twinCollection;
    }

    private static void addMetadata(TwinCollection twinCollection, Map<? extends String, Object> metadata) {
        String lastUpdated = null;
        Integer lastUpdatedVersion = null;
        String lastUpdatedBy = null;
        String lastUpdatedByDigest = null;
        for (Map.Entry<? extends String, Object> entry : metadata.entrySet()) {
            Object valueInCollection;
            String key = entry.getKey();
            if (key.equals("$lastUpdated")) {
                lastUpdated = (String)entry.getValue();
                continue;
            }
            if (key.equals("$lastUpdatedVersion") && entry.getValue() instanceof Number) {
                lastUpdatedVersion = ((Number)entry.getValue()).intValue();
                continue;
            }
            if (key.equals("$lastUpdatedBy")) {
                lastUpdatedBy = (String)entry.getValue();
                continue;
            }
            if (key.equals("$lastUpdatedByDigest")) {
                lastUpdatedByDigest = (String)entry.getValue();
                continue;
            }
            TwinMetadata twinMetadata = TwinMetadata.tryExtractFromMap(entry.getValue());
            if (twinMetadata != null) {
                twinCollection.metadataMap.put(key, twinMetadata);
            }
            if (!((valueInCollection = twinCollection.get(key)) instanceof TwinCollection)) continue;
            TwinCollection.addMetadata((TwinCollection)valueInCollection, (Map)entry.getValue());
        }
        if (lastUpdatedVersion != null || !Tools.isNullOrEmpty(lastUpdated).booleanValue()) {
            twinCollection.twinMetadata = new TwinMetadata(lastUpdated, lastUpdatedVersion, lastUpdatedBy, lastUpdatedByDigest);
        }
    }

    public JsonObject toJsonObject() {
        JsonObject object = ParserUtility.mapToJsonElement(this).getAsJsonObject();
        if (this.version != null) {
            object.addProperty(VERSION_TAG, (Number)this.version);
        }
        return object;
    }

    JsonElement toJsonElementWithMetadata() {
        JsonObject jsonObject = ParserUtility.mapToJsonElement(this).getAsJsonObject();
        if (this.version != null) {
            jsonObject.addProperty(VERSION_TAG, (Number)this.version);
        }
        JsonObject jsonMetadata = new JsonObject();
        this.fillJsonMetadata(jsonMetadata);
        if (!jsonMetadata.entrySet().isEmpty()) {
            jsonObject.add(METADATA_TAG, (JsonElement)jsonMetadata);
        }
        return jsonObject;
    }

    private void fillJsonMetadata(JsonObject jsonMetadata) {
        if (this.twinMetadata != null) {
            jsonMetadata.addProperty("$lastUpdated", ParserUtility.dateTimeUtcToString(this.twinMetadata.getLastUpdated()));
            jsonMetadata.addProperty("$lastUpdatedVersion", (Number)this.twinMetadata.getLastUpdatedVersion());
            if (this.twinMetadata.getLastUpdatedBy() != null) {
                jsonMetadata.addProperty("$lastUpdatedBy", this.twinMetadata.getLastUpdatedBy());
            }
            if (this.twinMetadata.getLastUpdatedByDigest() != null) {
                jsonMetadata.addProperty("$lastUpdatedByDigest", this.twinMetadata.getLastUpdatedByDigest());
            }
        }
        for (Map.Entry<String, TwinMetadata> entry : this.metadataMap.entrySet()) {
            if (entry.getValue() == null) continue;
            JsonObject subMapJson = entry.getValue().toJsonElement().getAsJsonObject();
            Object value = this.get(entry.getKey());
            if (value instanceof TwinCollection) {
                ((TwinCollection)value).fillJsonMetadata(subMapJson);
            }
            jsonMetadata.add(entry.getKey(), (JsonElement)subMapJson);
        }
    }

    public final Integer getVersion() {
        return this.version;
    }

    public final void setVersion(Integer version) {
        this.version = version;
    }

    public final TwinMetadata getTwinMetadata() {
        return this.twinMetadata;
    }

    final void setTwinMetadata(TwinMetadata twinMetadata) {
        this.twinMetadata = twinMetadata;
    }

    public final TwinMetadata getTwinMetadata(String key) {
        return this.metadataMap.get(key);
    }

    @Override
    public String toString() {
        return this.toJsonElementWithMetadata().toString();
    }
}

