/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.twin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.service.twin.TwinCollection;

public class TwinProperties {
    private static final String DESIRED_PROPERTIES_TAG = "desired";
    @Expose
    @SerializedName(value="desired")
    private TwinCollection desired;
    private static final String REPORTED_PROPERTIES_TAG = "reported";
    @Expose
    @SerializedName(value="reported")
    private TwinCollection reported;

    TwinProperties(TwinCollection desired, TwinCollection reported) {
        if (desired == null && reported == null) {
            throw new IllegalArgumentException("Desired property cannot be null.");
        }
        if (desired != null) {
            this.desired = TwinCollection.createFromRawCollection(desired);
        }
        if (reported != null) {
            this.reported = TwinCollection.createFromRawCollection(reported);
        }
    }

    JsonElement toJsonElement() {
        JsonObject twinJson = new JsonObject();
        if (this.desired != null) {
            twinJson.add(DESIRED_PROPERTIES_TAG, (JsonElement)this.desired.toJsonObject());
        }
        if (this.reported != null) {
            twinJson.add(REPORTED_PROPERTIES_TAG, (JsonElement)this.reported.toJsonObject());
        }
        return twinJson;
    }

    JsonElement toJsonElementWithMetadata() {
        JsonObject twinJson = new JsonObject();
        if (this.desired != null) {
            twinJson.add(DESIRED_PROPERTIES_TAG, this.desired.toJsonElementWithMetadata());
        }
        if (this.reported != null) {
            twinJson.add(REPORTED_PROPERTIES_TAG, this.reported.toJsonElementWithMetadata());
        }
        return twinJson;
    }

    public TwinCollection getDesired() {
        return this.desired;
    }

    public TwinCollection getReported() {
        return this.reported;
    }

    public String toString() {
        return this.toJsonElementWithMetadata().toString();
    }

    TwinProperties() {
    }
}

