/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class ParserUtility {
    private static final String DATEFORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String OFFSETFORMAT = "yyyy-MM-dd'T'HH:mm:ssXXX";
    static final DateTimeFormatter UTC_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    private static final String TIMEZONE_UTC = "UTC";
    private static final String SELECT = "select";
    private static final String FROM = "from";
    private static final int NO_MILLISECONDS_IN_DATE = 0;
    private static final int DATE_AND_TIME_IN_DATE = 0;
    private static final int MILLISECONDS_IN_DATE = 1;
    private static final int EXPECTED_PARTS_IN_DATE = 2;
    private static final int MAX_MILLISECONDS_LENGTH_IN_DATE = 3;
    private static final double MILLISECONDS_NUMERIC_BASE = 10.0;
    private static final String MILLISECONDS_REGEX = "[.,Z]";

    public static void validateStringUTF8(String str) throws IllegalArgumentException {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("parameter is null or empty");
        }
        if (str.getBytes(StandardCharsets.UTF_8).length != str.length()) {
            throw new IllegalArgumentException("parameter contains non UTF-8 character");
        }
    }

    public static void validateQuery(String query) throws IllegalArgumentException {
        try {
            ParserUtility.validateStringUTF8(query);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The provided query is not valid");
        }
        if (!query.toLowerCase().contains(SELECT) || !query.toLowerCase().contains(FROM)) {
            throw new IllegalArgumentException("Query must contain select and from");
        }
    }

    public static void validateBlobName(String blobName) throws IllegalArgumentException {
        try {
            ParserUtility.validateStringUTF8(blobName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The provided blob name is not valid");
        }
        if (blobName.length() > 1024) {
            throw new IllegalArgumentException("The provided blob name exceed maximum size of 1024 characters");
        }
        if (blobName.split("/").length > 254) {
            throw new IllegalArgumentException("The provided blob name exceed 254 path segments");
        }
    }

    public static void validateObject(Object val) throws IllegalArgumentException {
        if (val == null) {
            throw new IllegalArgumentException("parameter is null");
        }
    }

    public static void validateMap(Map<String, Object> map) throws IllegalArgumentException {
        if (map != null) {
            ParserUtility.validateMapInternal(map);
        }
    }

    private static void validateMapInternal(Map<String, Object> map) throws IllegalArgumentException {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value != null && (value.getClass().isArray() || value.getClass().isLocalClass())) {
                throw new IllegalArgumentException("Map contains illegal value type " + value.getClass().getName());
            }
            if (!(value instanceof Map)) continue;
            ParserUtility.validateMapInternal((Map)value);
        }
    }

    public static Date getDateTimeUtc(String dataTime) throws IllegalArgumentException {
        Date dateTimeUtc;
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATEFORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone(TIMEZONE_UTC));
        if (dataTime == null || dataTime.isEmpty()) {
            throw new IllegalArgumentException("date is null, empty, or invalid");
        }
        try {
            int milliseconds;
            String[] splitDateTime = dataTime.split(MILLISECONDS_REGEX);
            if (splitDateTime.length > 2) {
                throw new IllegalArgumentException("invalid time:" + dataTime);
            }
            if (splitDateTime.length == 2 && !splitDateTime[1].isEmpty()) {
                int millisecondsLength = splitDateTime[1].length();
                if (millisecondsLength > 3) {
                    millisecondsLength = 3;
                }
                milliseconds = Integer.parseInt(splitDateTime[1].substring(0, millisecondsLength)) * (int)Math.pow(10.0, 3 - millisecondsLength);
            } else {
                milliseconds = 0;
            }
            dateTimeUtc = new Date(dateFormat.parse(splitDateTime[0]).getTime() + (long)milliseconds);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("invalid time:" + dataTime);
        }
        return dateTimeUtc;
    }

    public static Date stringToDateTimeOffset(String dateTime) throws IllegalArgumentException {
        Date dateTimeOffset;
        SimpleDateFormat dateFormat = new SimpleDateFormat(OFFSETFORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone(TIMEZONE_UTC));
        if (dateTime == null || dateTime.isEmpty()) {
            throw new IllegalArgumentException("date is null or empty");
        }
        try {
            dateTimeOffset = dateFormat.parse(dateTime);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("invalid time:" + e.toString());
        }
        return dateTimeOffset;
    }

    public static String dateTimeUtcToString(Date date) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("date cannot be null");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATEFORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone(TIMEZONE_UTC));
        StringBuilder dateStr = new StringBuilder();
        dateStr.append(dateFormat.format(date));
        dateStr.append(".");
        int milliseconds = (int)(date.getTime() % 1000L);
        milliseconds = milliseconds < 0 ? milliseconds + 1000 : milliseconds;
        dateStr.append(milliseconds);
        dateStr.append("Z");
        return dateStr.toString();
    }

    public static String getUTCDateStringFromDate(Date date) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("The provided date cannot be null");
        }
        OffsetDateTime offsetDateTime = date.toInstant().atOffset(ZoneOffset.UTC);
        return offsetDateTime.format(UTC_DATETIME_FORMATTER);
    }

    public static JsonElement mapToJsonElement(Map<String, Object> map) throws IllegalArgumentException {
        Gson gson = new GsonBuilder().serializeNulls().create();
        JsonObject json = new JsonObject();
        if (map == null) {
            throw new IllegalArgumentException("null map to parse");
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) {
                json.addProperty(entry.getKey(), (String)null);
                continue;
            }
            if (entry.getValue() instanceof Map) {
                json.add(entry.getKey(), ParserUtility.mapToJsonElement((Map)entry.getValue()));
                continue;
            }
            json.add(entry.getKey(), gson.toJsonTree(entry.getValue()));
        }
        return json;
    }

    public static Object resolveJsonElement(JsonElement jsonElement) {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        if (jsonElement.isJsonPrimitive()) {
            return jsonElement.getAsJsonPrimitive();
        }
        if (jsonElement.isJsonObject()) {
            return jsonElement.getAsJsonObject();
        }
        if (jsonElement.isJsonArray()) {
            return jsonElement.getAsJsonArray();
        }
        throw new IllegalArgumentException("Invalid DeviceMethodResponse payload: unknown payload type: " + jsonElement.getClass());
    }

    private static Object getJsonPrimitiveValue(JsonPrimitive jsonPrimitive) {
        if (jsonPrimitive.isNumber()) {
            return jsonPrimitive.getAsNumber();
        }
        if (jsonPrimitive.isBoolean()) {
            return jsonPrimitive.getAsBoolean();
        }
        return jsonPrimitive.getAsString();
    }

    public static Map<String, Object> getJsonObjectValue(JsonObject jsonObject) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            map.put((String)entry.getKey(), ParserUtility.resolveJsonElement((JsonElement)entry.getValue()));
        }
        return map;
    }

    private static List<Object> getJsonArrayValue(JsonArray jsonArray) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonElement element : jsonArray.getAsJsonArray()) {
            list.add(ParserUtility.resolveJsonElement(element));
        }
        return list;
    }
}

