/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import java.net.InetSocketAddress;
import java.net.Proxy;

public final class ProxyOptions {
    private final Proxy proxy;

    public ProxyOptions(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("Proxy cannot be null");
        }
        if (proxy.type() != Proxy.Type.HTTP) {
            throw new IllegalArgumentException("Service proxy options only support using HTTP proxies");
        }
        this.proxy = proxy;
    }

    public String getHostName() {
        if (this.proxy.address() instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)this.proxy.address();
            return addr.getHostName();
        }
        throw new UnsupportedOperationException("Unsupported proxy type, could not get host name. Proxy address was not an instance of java.net.InetSocketAddress.");
    }

    public int getPort() {
        if (this.proxy.address() instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)this.proxy.address();
            return addr.getPort();
        }
        throw new UnsupportedOperationException("Unsupported proxy type, could not get port. Proxy address was not an instance of java.net.InetSocketAddress.");
    }

    public Proxy getProxy() {
        return this.proxy;
    }
}

