/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.auth;

import com.microsoft.azure.sdk.iot.service.auth.AuthenticationType;
import com.microsoft.azure.sdk.iot.service.auth.SymmetricKey;
import com.microsoft.azure.sdk.iot.service.auth.X509Thumbprint;

public class AuthenticationMechanism {
    private SymmetricKey symmetricKey;
    private X509Thumbprint thumbprint;
    private AuthenticationType type;
    private static final String ILLEGAL_SYMMETRIC_KEY_STRING = "The provided symmetric key cannot be null";
    private static final String ILLEGAL_AUTHENTICATION_TYPE = "The provided authentication type cannot be null";

    public AuthenticationMechanism(SymmetricKey symmetricKey) {
        this.symmetricKey = symmetricKey;
        this.type = AuthenticationType.SAS;
    }

    public AuthenticationMechanism(String primaryThumbprint, String secondaryThumbprint) {
        this.thumbprint = new X509Thumbprint(primaryThumbprint, secondaryThumbprint);
        this.type = AuthenticationType.SELF_SIGNED;
    }

    public AuthenticationMechanism(AuthenticationType authenticationType) {
        this.type = authenticationType;
        if (this.type != AuthenticationType.CERTIFICATE_AUTHORITY) {
            if (this.type == AuthenticationType.SELF_SIGNED) {
                this.thumbprint = new X509Thumbprint();
            } else if (this.type == AuthenticationType.SAS) {
                this.symmetricKey = new SymmetricKey();
            }
        }
    }

    public SymmetricKey getSymmetricKey() {
        return this.symmetricKey;
    }

    public String getPrimaryThumbprint() {
        if (this.thumbprint == null) {
            return null;
        }
        return this.thumbprint.getPrimaryThumbprint();
    }

    public String getSecondaryThumbprint() {
        if (this.thumbprint == null) {
            return null;
        }
        return this.thumbprint.getSecondaryThumbprint();
    }

    public void setSymmetricKey(SymmetricKey symmetricKey) {
        this.symmetricKey = symmetricKey;
        this.type = AuthenticationType.SAS;
    }

    public void setPrimaryThumbprint(String primaryThumbprint) {
        if (this.thumbprint == null) {
            this.thumbprint = new X509Thumbprint();
        }
        this.thumbprint.setPrimaryThumbprint(primaryThumbprint);
        this.type = AuthenticationType.SELF_SIGNED;
    }

    public void setSecondaryThumbprint(String secondaryThumbprint) {
        if (this.thumbprint == null) {
            this.thumbprint = new X509Thumbprint();
        }
        this.thumbprint.setSecondaryThumbprint(secondaryThumbprint);
        this.type = AuthenticationType.SELF_SIGNED;
    }

    public AuthenticationType getAuthenticationType() {
        return this.type;
    }

    public void setAuthenticationType(AuthenticationType type) {
        this.type = type;
    }
}

