/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.auth;

import com.microsoft.azure.sdk.iot.service.auth.AuthenticationMethod;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionStringBuilder;
import java.net.MalformedURLException;
import java.net.URL;

public class IotHubConnectionString
extends IotHubConnectionStringBuilder {
    static final String VALUE_PAIR_DELIMITER = ";";
    static final String VALUE_PAIR_SEPARATOR = "=";
    static final String HOST_NAME_SEPARATOR = ".";
    static final String HOST_NAME_PROPERTY_NAME = "HostName";
    static final String SHARED_ACCESS_KEY_NAME_PROPERTY_NAME = "SharedAccessKeyName";
    static final String SHARED_ACCESS_KEY_PROPERTY_NAME = "SharedAccessKey";
    static final String SHARED_ACCESS_SIGNATURE_PROPERTY_NAME = "SharedAccessSignature";
    String hostName;
    String iotHubName;
    AuthenticationMethod authenticationMethod;
    String sharedAccessKeyName;
    String sharedAccessKey;
    String sharedAccessSignature;
    private static final String URL_SEPARATOR_0 = "/";
    private static final String URL_SEPARATOR_1 = "?";
    private static final String URL_SEPARATOR_2 = "&";
    private static final String URL_HTTPS = "https://";
    private static final String URL_PATH_DEVICES = "devices";
    private static final String URL_PATH_MODULES = "modules";
    private static final String URL_PATH_CONFIG = "configurations";
    private static final String URL_API_VERSION = "api-version=2021-04-12";
    private static final String URL_MAX_COUNT = "top=";
    private static final String URL_PATH_DEVICESTATISTICS = "statistics";
    private static final String USER_SEPARATOR = "@";
    private static final String USER_SAS = "SAS.";
    private static final String USER_ROOT = "root.";
    private static final String URL_PATH_TWIN = "twins";
    private static final String URL_PATH_METHODS = "methods";
    private static final String URL_PATH_TWIN_DEVICES = "devices";
    private static final String URL_PATH_JOBS = "jobs";
    private static final String URL_PATH_VERSION = "v2";
    private static final String URL_PATH_QUERY = "query";
    private static final String URL_PATH_JOB_TYPE = "jobType";
    private static final String URL_PATH_JOB_STATUS = "jobStatus";
    private static final String URL_PATH_CANCEL = "cancel";
    private static final String URL_PATH_APPLY_CONTENT_CONFIGURATION = "applyConfigurationContent";

    IotHubConnectionString() {
    }

    public URL getUrlMethod(String deviceId) throws MalformedURLException, IllegalArgumentException {
        return IotHubConnectionString.getUrlMethod(this.hostName, deviceId);
    }

    public static URL getUrlMethod(String hostName, String deviceId) throws MalformedURLException, IllegalArgumentException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("device name cannot be empty or null");
        }
        String stringBuilder = URL_HTTPS + hostName + URL_SEPARATOR_0 + URL_PATH_TWIN + URL_SEPARATOR_0 + deviceId + URL_SEPARATOR_0 + URL_PATH_METHODS + URL_SEPARATOR_1 + URL_API_VERSION;
        return new URL(stringBuilder);
    }

    public URL getUrlModuleMethod(String deviceId, String moduleId) throws MalformedURLException, IllegalArgumentException {
        return IotHubConnectionString.getUrlModuleMethod(this.hostName, deviceId, moduleId);
    }

    public static URL getUrlModuleMethod(String hostName, String deviceId, String moduleId) throws MalformedURLException, IllegalArgumentException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("device name cannot be empty or null");
        }
        if (moduleId == null || moduleId.isEmpty()) {
            throw new IllegalArgumentException("module name cannot be empty or null");
        }
        String stringBuilder = URL_HTTPS + hostName + URL_SEPARATOR_0 + URL_PATH_TWIN + URL_SEPARATOR_0 + deviceId + URL_SEPARATOR_0 + URL_PATH_MODULES + URL_SEPARATOR_0 + moduleId + URL_SEPARATOR_0 + URL_PATH_METHODS + URL_SEPARATOR_1 + URL_API_VERSION;
        return new URL(stringBuilder);
    }

    public URL getUrlJobs(String jobId) throws MalformedURLException, IllegalArgumentException {
        return IotHubConnectionString.getUrlJobs(this.hostName, jobId);
    }

    public static URL getUrlJobs(String hostName, String jobId) throws MalformedURLException, IllegalArgumentException {
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("job name cannot be empty or null");
        }
        String stringBuilder = URL_HTTPS + hostName + URL_SEPARATOR_0 + URL_PATH_JOBS + URL_SEPARATOR_0 + URL_PATH_VERSION + URL_SEPARATOR_0 + jobId + URL_SEPARATOR_1 + URL_API_VERSION;
        return new URL(stringBuilder);
    }

    public URL getUrlTwinQuery() throws MalformedURLException {
        return IotHubConnectionString.getUrlTwinQuery(this.hostName);
    }

    public static URL getUrlTwinQuery(String hostName) throws MalformedURLException {
        String stringBuilder = URL_HTTPS + hostName + URL_SEPARATOR_0 + "devices" + URL_SEPARATOR_0 + URL_PATH_QUERY + URL_SEPARATOR_1 + URL_API_VERSION;
        return new URL(stringBuilder);
    }

    public URL getUrlQuery(String jobType, String jobStatus) throws MalformedURLException {
        return IotHubConnectionString.getUrlQuery(this.hostName, jobType, jobStatus);
    }

    public static URL getUrlQuery(String hostName, String jobType, String jobStatus) throws MalformedURLException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URL_HTTPS);
        stringBuilder.append(hostName);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_JOBS);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_VERSION);
        stringBuilder.append(URL_SEPARATOR_0);
        stringBuilder.append(URL_PATH_QUERY);
        stringBuilder.append(URL_SEPARATOR_1);
        if (jobType != null && !jobType.isEmpty()) {
            stringBuilder.append(URL_PATH_JOB_TYPE);
            stringBuilder.append(VALUE_PAIR_SEPARATOR);
            stringBuilder.append(jobType);
            stringBuilder.append(URL_SEPARATOR_2);
        }
        if (jobStatus != null && !jobStatus.isEmpty()) {
            stringBuilder.append(URL_PATH_JOB_STATUS);
            stringBuilder.append(VALUE_PAIR_SEPARATOR);
            stringBuilder.append(jobStatus);
            stringBuilder.append(URL_SEPARATOR_2);
        }
        stringBuilder.append(URL_API_VERSION);
        return new URL(stringBuilder.toString());
    }

    public URL getUrlJobsCancel(String jobId) throws MalformedURLException, IllegalArgumentException {
        return IotHubConnectionString.getUrlJobsCancel(this.hostName, jobId);
    }

    public static URL getUrlJobsCancel(String hostName, String jobId) throws MalformedURLException, IllegalArgumentException {
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("job name cannot be empty or null");
        }
        String stringBuilder = URL_HTTPS + hostName + URL_SEPARATOR_0 + URL_PATH_JOBS + URL_SEPARATOR_0 + URL_PATH_VERSION + URL_SEPARATOR_0 + jobId + URL_SEPARATOR_0 + URL_PATH_CANCEL + URL_SEPARATOR_1 + URL_API_VERSION;
        return new URL(stringBuilder);
    }

    public URL getUrlTwin(String deviceId) throws MalformedURLException, IllegalArgumentException {
        return IotHubConnectionString.getUrlTwin(this.hostName, deviceId);
    }

    public static URL getUrlTwin(String hostName, String deviceId) throws MalformedURLException, IllegalArgumentException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("device name cannot be empty or null");
        }
        String stringBuilder = URL_HTTPS + hostName + URL_SEPARATOR_0 + URL_PATH_TWIN + URL_SEPARATOR_0 + deviceId + URL_SEPARATOR_1 + URL_API_VERSION;
        return new URL(stringBuilder);
    }

    public URL getUrlModuleTwin(String deviceId, String moduleId) throws MalformedURLException, IllegalArgumentException {
        return IotHubConnectionString.getUrlModuleTwin(this.hostName, deviceId, moduleId);
    }

    public static URL getUrlModuleTwin(String hostName, String deviceId, String moduleId) throws MalformedURLException, IllegalArgumentException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("device name cannot be empty or null");
        }
        if (moduleId == null || moduleId.isEmpty()) {
            throw new IllegalArgumentException("module id cannot be empty or null");
        }
        String stringBuilder = URL_HTTPS + hostName + URL_SEPARATOR_0 + URL_PATH_TWIN + URL_SEPARATOR_0 + deviceId + URL_SEPARATOR_0 + URL_PATH_MODULES + URL_SEPARATOR_0 + moduleId + URL_SEPARATOR_1 + URL_API_VERSION;
        return new URL(stringBuilder);
    }

    public URL getUrlDevice(String deviceId) throws MalformedURLException, IllegalArgumentException {
        return IotHubConnectionString.getUrlDevice(this.hostName, deviceId);
    }

    public static URL getUrlDevice(String hostName, String deviceId) throws MalformedURLException, IllegalArgumentException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("device name cannot be empty or null");
        }
        String stringBuilder = URL_HTTPS + hostName + URL_SEPARATOR_0 + "devices" + URL_SEPARATOR_0 + deviceId + URL_SEPARATOR_1 + URL_API_VERSION;
        return new URL(stringBuilder);
    }

    public URL getUrlModule(String deviceId, String moduleId) throws MalformedURLException, IllegalArgumentException {
        return IotHubConnectionString.getUrlModule(this.hostName, deviceId, moduleId);
    }

    public static URL getUrlModule(String hostName, String deviceId, String moduleId) throws MalformedURLException, IllegalArgumentException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("device name cannot be empty or null");
        }
        if (moduleId == null || moduleId.isEmpty()) {
            throw new IllegalArgumentException("module name cannot be empty or null");
        }
        String stringBuilder = URL_HTTPS + hostName + URL_SEPARATOR_0 + "devices" + URL_SEPARATOR_0 + deviceId + URL_SEPARATOR_0 + URL_PATH_MODULES + URL_SEPARATOR_0 + moduleId + URL_SEPARATOR_1 + URL_API_VERSION;
        return new URL(stringBuilder);
    }

    public URL getUrlApplyConfigurationContent(String deviceId) throws MalformedURLException, IllegalArgumentException {
        return IotHubConnectionString.getUrlApplyConfigurationContent(this.hostName, deviceId);
    }

    public static URL getUrlApplyConfigurationContent(String hostName, String deviceId) throws MalformedURLException, IllegalArgumentException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("deviceId cannot be null");
        }
        String stringBuilder = URL_HTTPS + hostName + URL_SEPARATOR_0 + "devices" + URL_SEPARATOR_0 + deviceId + URL_SEPARATOR_0 + URL_PATH_APPLY_CONTENT_CONFIGURATION + URL_SEPARATOR_1 + URL_API_VERSION;
        return new URL(stringBuilder);
    }

    public URL getUrlConfiguration(String configurationId) throws MalformedURLException, IllegalArgumentException {
        return IotHubConnectionString.getUrlConfiguration(this.hostName, configurationId);
    }

    public static URL getUrlConfiguration(String hostName, String configurationId) throws MalformedURLException, IllegalArgumentException {
        if (configurationId == null || configurationId.isEmpty()) {
            throw new IllegalArgumentException("configuration id cannot be empty or null");
        }
        String stringBuilder = URL_HTTPS + hostName + URL_SEPARATOR_0 + URL_PATH_CONFIG + URL_SEPARATOR_0 + configurationId + URL_SEPARATOR_1 + URL_API_VERSION;
        return new URL(stringBuilder);
    }

    public URL getUrlConfigurationsList(Integer maxCount) throws MalformedURLException, IllegalArgumentException {
        return IotHubConnectionString.getUrlConfigurationsList(this.hostName, maxCount);
    }

    public static URL getUrlConfigurationsList(String hostName, Integer maxCount) throws MalformedURLException, IllegalArgumentException {
        if (maxCount == null || maxCount < 1) {
            throw new IllegalArgumentException("maxCount cannot be null or less then 1");
        }
        String stringBuilder = URL_HTTPS + hostName + URL_SEPARATOR_0 + URL_PATH_CONFIG + URL_SEPARATOR_1 + URL_MAX_COUNT + maxCount.toString() + URL_SEPARATOR_2 + URL_API_VERSION;
        return new URL(stringBuilder);
    }

    public URL getUrlModulesOnDevice(String deviceId) throws MalformedURLException, IllegalArgumentException {
        return IotHubConnectionString.getUrlModulesOnDevice(this.hostName, deviceId);
    }

    public static URL getUrlModulesOnDevice(String hostName, String deviceId) throws MalformedURLException, IllegalArgumentException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("device name cannot be empty or null");
        }
        String stringBuilder = URL_HTTPS + hostName + URL_SEPARATOR_0 + "devices" + URL_SEPARATOR_0 + deviceId + URL_SEPARATOR_0 + URL_PATH_MODULES + URL_SEPARATOR_1 + URL_API_VERSION;
        return new URL(stringBuilder);
    }

    public URL getUrlDeviceList(Integer maxCount) throws MalformedURLException, IllegalArgumentException {
        return IotHubConnectionString.getUrlDeviceList(this.hostName, maxCount);
    }

    public static URL getUrlDeviceList(String hostName, Integer maxCount) throws MalformedURLException, IllegalArgumentException {
        if (maxCount == null || maxCount < 1) {
            throw new IllegalArgumentException("maxCount cannot be null or less then 1");
        }
        String stringBuilder = URL_HTTPS + hostName + URL_SEPARATOR_0 + "devices" + URL_SEPARATOR_0 + URL_SEPARATOR_1 + URL_MAX_COUNT + maxCount.toString() + URL_SEPARATOR_2 + URL_API_VERSION;
        return new URL(stringBuilder);
    }

    public URL getUrlDeviceStatistics() throws MalformedURLException {
        return IotHubConnectionString.getUrlDeviceStatistics(this.hostName);
    }

    public static URL getUrlDeviceStatistics(String hostName) throws MalformedURLException {
        String stringBuilder = URL_HTTPS + hostName + URL_SEPARATOR_0 + URL_PATH_DEVICESTATISTICS + URL_SEPARATOR_0 + "devices" + URL_SEPARATOR_1 + URL_API_VERSION;
        return new URL(stringBuilder);
    }

    public URL getUrlCreateExportImportJob() throws MalformedURLException {
        return IotHubConnectionString.getUrlCreateExportImportJob(this.hostName);
    }

    public static URL getUrlCreateExportImportJob(String hostName) throws MalformedURLException {
        String stringBuilder = URL_HTTPS + hostName + URL_SEPARATOR_0 + URL_PATH_JOBS + URL_SEPARATOR_0 + "create" + URL_SEPARATOR_1 + URL_API_VERSION;
        return new URL(stringBuilder);
    }

    public URL getUrlImportExportJob(String jobId) throws MalformedURLException {
        return IotHubConnectionString.getUrlImportExportJob(this.hostName, jobId);
    }

    public static URL getUrlImportExportJob(String hostName, String jobId) throws MalformedURLException {
        String stringBuilder = URL_HTTPS + hostName + URL_SEPARATOR_0 + URL_PATH_JOBS + URL_SEPARATOR_0 + jobId + URL_SEPARATOR_1 + URL_API_VERSION;
        return new URL(stringBuilder);
    }

    public String toString() {
        return "HostName=" + this.hostName + VALUE_PAIR_DELIMITER + SHARED_ACCESS_KEY_NAME_PROPERTY_NAME + VALUE_PAIR_SEPARATOR + this.sharedAccessKeyName + VALUE_PAIR_DELIMITER + SHARED_ACCESS_KEY_PROPERTY_NAME + VALUE_PAIR_SEPARATOR + this.sharedAccessKey + VALUE_PAIR_DELIMITER + SHARED_ACCESS_SIGNATURE_PROPERTY_NAME + VALUE_PAIR_SEPARATOR + this.sharedAccessSignature;
    }

    public String getIotHubName() {
        return this.iotHubName;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public String getSharedAccessKeyName() {
        return this.sharedAccessKeyName;
    }

    public String getSharedAccessKey() {
        return this.sharedAccessKey;
    }

    public String getSharedAccessSignature() {
        return this.sharedAccessSignature;
    }

    public String getHostName() {
        return this.hostName;
    }

    void setSharedAccessKeyName(String sharedAccessKeyName) {
        this.sharedAccessKeyName = sharedAccessKeyName;
    }

    void setSharedAccessKey(String sharedAccessKey) {
        this.sharedAccessKey = sharedAccessKey;
    }

    void setSharedAccessSignature(String sharedAccessSignature) {
        this.sharedAccessSignature = sharedAccessSignature;
    }
}

