/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.auth;

import com.microsoft.azure.sdk.iot.service.auth.AuthenticationMethod;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.auth.ServiceAuthenticationWithSharedAccessPolicyKey;
import com.microsoft.azure.sdk.iot.service.auth.ServiceAuthenticationWithSharedAccessPolicyToken;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class IotHubConnectionStringBuilder {
    private static final String HOST_NAME_REGEX = "[a-zA-Z0-9_\\-\\.]+$";
    private static final String SHARED_ACCESS_KEY_NAME_REGEX = "^[a-zA-Z0-9_\\-@\\.]+$";
    private static final String SHARED_ACCESS_KEY_REGEX = "^.+$";
    private static final String SHARED_ACCESS_SIGNATURE_REGEX = "^.+$";

    public static IotHubConnectionString createIotHubConnectionString(String connectionString) {
        if (connectionString == null || connectionString.isEmpty()) {
            throw new IllegalArgumentException("connection string cannot be null or empty");
        }
        IotHubConnectionString iotHubConnectionString = new IotHubConnectionString();
        IotHubConnectionStringBuilder.parse(connectionString, iotHubConnectionString);
        return iotHubConnectionString;
    }

    public static IotHubConnectionString createIotHubConnectionString(String hostName, AuthenticationMethod authenticationMethod) {
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        if (authenticationMethod == null) {
            throw new IllegalArgumentException("authenticationMethod cannot be null");
        }
        IotHubConnectionString iotHubConnectionString = new IotHubConnectionString();
        IotHubConnectionStringBuilder.setHostName(hostName, iotHubConnectionString);
        IotHubConnectionStringBuilder.setAuthenticationMethod(authenticationMethod, iotHubConnectionString);
        IotHubConnectionStringBuilder.validate(iotHubConnectionString);
        return iotHubConnectionString;
    }

    private static void parse(String connectionString, IotHubConnectionString iotHubConnectionString) {
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        if (connectionString == null || connectionString.isEmpty()) {
            throw new IllegalArgumentException("connectionString cannot be null or empty");
        }
        if (iotHubConnectionString == null) {
            throw new IllegalArgumentException("iotHubConnectionString cannot be null");
        }
        StringTokenizer stringTokenizer1 = new StringTokenizer(connectionString, ";");
        while (stringTokenizer1.hasMoreTokens()) {
            String currentToken = stringTokenizer1.nextToken();
            String[] splitString = currentToken.split("=", 2);
            if (splitString.length != 2) continue;
            keyValueMap.put(splitString[0], splitString[1]);
        }
        iotHubConnectionString.hostName = IotHubConnectionStringBuilder.getValueStringByKey(keyValueMap, "HostName");
        iotHubConnectionString.sharedAccessKeyName = IotHubConnectionStringBuilder.getValueStringByKey(keyValueMap, "SharedAccessKeyName");
        iotHubConnectionString.sharedAccessKey = IotHubConnectionStringBuilder.getValueStringByKey(keyValueMap, "SharedAccessKey");
        iotHubConnectionString.sharedAccessSignature = IotHubConnectionStringBuilder.getValueStringByKey(keyValueMap, "SharedAccessSignature");
        iotHubConnectionString.iotHubName = IotHubConnectionStringBuilder.parseIotHubName(iotHubConnectionString);
        if (iotHubConnectionString.sharedAccessKey == null || iotHubConnectionString.sharedAccessKey.isEmpty()) {
            iotHubConnectionString.authenticationMethod = new ServiceAuthenticationWithSharedAccessPolicyToken(iotHubConnectionString.sharedAccessKeyName, iotHubConnectionString.sharedAccessSignature);
        }
        if (iotHubConnectionString.sharedAccessSignature == null || iotHubConnectionString.sharedAccessSignature.isEmpty()) {
            iotHubConnectionString.authenticationMethod = new ServiceAuthenticationWithSharedAccessPolicyKey(iotHubConnectionString.sharedAccessKeyName, iotHubConnectionString.sharedAccessKey);
        }
        IotHubConnectionStringBuilder.validate(iotHubConnectionString);
    }

    private static String parseIotHubName(IotHubConnectionString iotHubConnectionString) {
        int index = iotHubConnectionString.hostName.indexOf(".");
        if (index >= 0) {
            return iotHubConnectionString.hostName.substring(0, index);
        }
        return "";
    }

    private static void validate(IotHubConnectionString iotHubConnectionString) throws IllegalArgumentException {
        if (iotHubConnectionString.sharedAccessKeyName == null || iotHubConnectionString.sharedAccessKeyName.isEmpty()) {
            throw new IllegalArgumentException("SharedAccessKeyName cannot be null or empty");
        }
        if ((iotHubConnectionString.sharedAccessKey == null || iotHubConnectionString.sharedAccessKey.isEmpty()) && (iotHubConnectionString.sharedAccessSignature == null || iotHubConnectionString.sharedAccessSignature.isEmpty())) {
            throw new IllegalArgumentException("Should specify either sharedAccessKey or sharedAccessSignature");
        }
        IotHubConnectionStringBuilder.validateFormat(iotHubConnectionString.hostName, HOST_NAME_REGEX);
        IotHubConnectionStringBuilder.validateFormatIfSpecified(iotHubConnectionString.sharedAccessKeyName, SHARED_ACCESS_KEY_NAME_REGEX);
        IotHubConnectionStringBuilder.validateFormatIfSpecified(iotHubConnectionString.sharedAccessKey, "^.+$");
        IotHubConnectionStringBuilder.validateFormatIfSpecified(iotHubConnectionString.sharedAccessSignature, "^.+$");
    }

    private static void validateFormat(String value, String regex) {
        Pattern pattern = Pattern.compile(regex);
        if (!pattern.matcher(value).matches()) {
            throw new IllegalArgumentException("The connection string has an invalid value for property.");
        }
    }

    private static void validateFormatIfSpecified(String value, String regex) {
        if (value != null && !value.isEmpty()) {
            IotHubConnectionStringBuilder.validateFormat(value, regex);
        }
    }

    private static void setHostName(String hostName, IotHubConnectionString iotHubConnectionString) {
        IotHubConnectionStringBuilder.validateFormat(hostName, HOST_NAME_REGEX);
        iotHubConnectionString.hostName = hostName;
        iotHubConnectionString.iotHubName = IotHubConnectionStringBuilder.parseIotHubName(iotHubConnectionString);
    }

    private static void setAuthenticationMethod(AuthenticationMethod authenticationMethod, IotHubConnectionString iotHubConnectionString) {
        authenticationMethod.populate(iotHubConnectionString);
        iotHubConnectionString.authenticationMethod = authenticationMethod;
    }

    private static String getValueStringByKey(Map<String, ?> map, String keyName) {
        Object val;
        String retVal = map == null || keyName == null ? "" : ((val = map.get(keyName)) != null ? val.toString().trim() : "");
        return retVal;
    }
}

