/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.auth;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class IotHubSSLContext {
    private final SSLContext sslContext;
    private static final String SSL_CONTEXT_PROTOCOL = "TLSv1.2";
    private static final String CERTIFICATE_TYPE = "X.509";
    private static final String TRUSTED_IOT_HUB_CERT_PREFIX = "trustedIotHubCert-";

    public IotHubSSLContext() {
        try {
            this.sslContext = SSLContext.getInstance(SSL_CONTEXT_PROTOCOL);
            this.sslContext.init(null, null, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to build the default SSLContext instance", e);
        }
    }

    public IotHubSSLContext(SSLContext sslContext) {
        Objects.requireNonNull(sslContext);
        this.sslContext = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public static SSLContext getSSLContextFromString(String trustedCertificates) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        if (trustedCertificates == null || trustedCertificates.isEmpty()) {
            throw new IllegalArgumentException("The provided certificate string cannot be null or empty");
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(trustedCertificates.getBytes(StandardCharsets.UTF_8));){
            SSLContext sSLContext = IotHubSSLContext.getSSLContextFromStream(inputStream);
            return sSLContext;
        }
    }

    public static SSLContext getSSLContextFromFile(String trustedCertificatesFilePath) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        if (trustedCertificatesFilePath == null || trustedCertificatesFilePath.isEmpty()) {
            throw new IllegalArgumentException("The provided certificate path string cannot be null or empty");
        }
        try (FileInputStream fis = new FileInputStream(trustedCertificatesFilePath);){
            SSLContext sSLContext = IotHubSSLContext.getSSLContextFromStream(fis);
            return sSLContext;
        }
    }

    private static SSLContext getSSLContextFromStream(InputStream inputStream) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance(CERTIFICATE_TYPE);
        Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(inputStream);
        TrustManagerFactory trustManagerFactory = IotHubSSLContext.generateTrustManagerFactory(certificates);
        SSLContext sslContext = SSLContext.getInstance(SSL_CONTEXT_PROTOCOL);
        sslContext.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    private static TrustManagerFactory generateTrustManagerFactory(Collection<? extends Certificate> certificates) throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException {
        KeyStore trustKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustKeyStore.load(null);
        for (Certificate certificate : certificates) {
            trustKeyStore.setCertificateEntry(TRUSTED_IOT_HUB_CERT_PREFIX + UUID.randomUUID(), certificate);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustKeyStore);
        return trustManagerFactory;
    }
}

