/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.auth;

import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionString;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public final class IotHubServiceSasToken {
    private static final long DEFAULT_TOKEN_LIFESPAN_SECONDS = 3600L;
    private static final String TOKEN_FORMAT = "SharedAccessSignature sr=%s&sig=%s&se=%s&skn=%s";
    private final String resourceUri;
    private final String keyValue;
    private final long expiryTimeSeconds;
    private final String keyName;
    private final String token;
    private final long tokenLifespanSeconds;

    public IotHubServiceSasToken(IotHubConnectionString iotHubConnectionString) {
        this(iotHubConnectionString, 3600L);
    }

    private IotHubServiceSasToken(IotHubConnectionString iotHubConnectionString, long tokenLifespanSeconds) {
        if (iotHubConnectionString == null) {
            throw new IllegalArgumentException();
        }
        if (tokenLifespanSeconds <= 0L) {
            tokenLifespanSeconds = 3600L;
        }
        this.tokenLifespanSeconds = tokenLifespanSeconds;
        this.resourceUri = iotHubConnectionString.getHostName();
        this.keyValue = iotHubConnectionString.getSharedAccessKey();
        this.keyName = iotHubConnectionString.getSharedAccessKeyName();
        this.expiryTimeSeconds = this.buildExpiresOn();
        this.token = this.buildToken();
    }

    public final long getExpiryTimeMillis() {
        return this.expiryTimeSeconds * 1000L;
    }

    private String buildToken() {
        try {
            String targetUri = URLEncoder.encode(this.resourceUri.toLowerCase(), StandardCharsets.UTF_8.name());
            String toSign = targetUri + "\n" + this.expiryTimeSeconds;
            byte[] keyBytes = Base64.decodeBase64((byte[])this.keyValue.getBytes(StandardCharsets.UTF_8));
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(toSign.getBytes(StandardCharsets.UTF_8));
            String signature = URLEncoder.encode(Base64.encodeBase64String((byte[])rawHmac), StandardCharsets.UTF_8.name());
            return String.format(TOKEN_FORMAT, targetUri, signature, this.expiryTimeSeconds, this.keyName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private long buildExpiresOn() {
        long expiresOnDate = System.currentTimeMillis();
        return (expiresOnDate += this.tokenLifespanSeconds * 1000L) / 1000L;
    }

    public long getTokenLifespanSeconds() {
        return this.tokenLifespanSeconds;
    }

    public String toString() {
        return this.token;
    }
}

