/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.auth;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public class TokenCredentialCache {
    private static final int MINUTES_BEFORE_PROACTIVE_RENEWAL = 9;
    private final TokenCredential tokenCredential;
    private AccessToken accessToken;
    @SuppressFBWarnings(value={"MS_MUTABLE_ARRAY"})
    public static final String[] IOTHUB_PUBLIC_SCOPE = new String[]{"https://iothubs.azure.net/.default"};
    private static final String BEARER_TOKEN_PREFIX = "Bearer ";

    public TokenCredentialCache(TokenCredential tokenCredential) {
        Objects.requireNonNull(tokenCredential, "tokenCredential cannot be null");
        this.tokenCredential = tokenCredential;
    }

    public AccessToken getAccessToken() {
        if (this.accessToken == null || TokenCredentialCache.isAccessTokenCloseToExpiry(this.accessToken)) {
            this.accessToken = (AccessToken)this.tokenCredential.getToken(new TokenRequestContext().addScopes(IOTHUB_PUBLIC_SCOPE)).block();
        }
        return this.accessToken;
    }

    public String getTokenString() {
        return BEARER_TOKEN_PREFIX + this.getAccessToken().getToken();
    }

    public TokenCredential getTokenCredential() {
        return this.tokenCredential;
    }

    private static boolean isAccessTokenCloseToExpiry(AccessToken accessToken) {
        Duration remainingTimeToLive = Duration.between(Instant.now(), accessToken.getExpiresAt().toInstant());
        return remainingTimeToLive.toMinutes() <= 9L;
    }
}

