/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.auth;

import java.security.SecureRandom;

public class X509Thumbprint {
    private String primaryThumbprint;
    private String secondaryThumbprint;
    private static final int THUMBPRINT_DIGIT_MAX = 16;
    private static final int THUMBPRINT_LENGTH = 40;

    X509Thumbprint() {
        this.primaryThumbprint = this.generateValidThumbprint();
        this.secondaryThumbprint = this.generateValidThumbprint();
    }

    X509Thumbprint(String primaryThumbprint, String secondaryThumbprint) {
        this.primaryThumbprint = primaryThumbprint;
        this.secondaryThumbprint = secondaryThumbprint;
    }

    String getPrimaryThumbprint() {
        return this.primaryThumbprint;
    }

    String getSecondaryThumbprint() {
        return this.secondaryThumbprint;
    }

    void setPrimaryThumbprint(String primaryThumbprint) throws IllegalArgumentException {
        this.primaryThumbprint = primaryThumbprint;
    }

    void setSecondaryThumbprint(String secondaryThumbprint) throws IllegalArgumentException {
        this.secondaryThumbprint = secondaryThumbprint;
    }

    private String generateValidThumbprint() {
        StringBuilder thumbprint = new StringBuilder();
        SecureRandom rand = new SecureRandom();
        for (int i = 0; i < 40; ++i) {
            thumbprint.append(Integer.toHexString(rand.nextInt(16)));
        }
        return thumbprint.toString();
    }
}

