/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.configurations;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.google.gson.Gson;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionStringBuilder;
import com.microsoft.azure.sdk.iot.service.auth.IotHubServiceSasToken;
import com.microsoft.azure.sdk.iot.service.auth.TokenCredentialCache;
import com.microsoft.azure.sdk.iot.service.configurations.Configuration;
import com.microsoft.azure.sdk.iot.service.configurations.ConfigurationContent;
import com.microsoft.azure.sdk.iot.service.configurations.ConfigurationsClientOptions;
import com.microsoft.azure.sdk.iot.service.configurations.serializers.ConfigurationParser;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpMethod;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpRequest;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpResponse;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationsClient {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationsClient.class);
    private final String hostName;
    private TokenCredentialCache credentialCache;
    private AzureSasCredential azureSasCredential;
    private IotHubConnectionString iotHubConnectionString;
    private final ConfigurationsClientOptions options;

    public ConfigurationsClient(String connectionString) {
        this(connectionString, ConfigurationsClientOptions.builder().build());
    }

    public ConfigurationsClient(String connectionString, ConfigurationsClientOptions options) {
        if (connectionString == null || connectionString.isEmpty()) {
            throw new IllegalArgumentException("The provided connection string cannot be null or empty");
        }
        if (options == null) {
            throw new IllegalArgumentException("RegistryClientOptions cannot be null for this constructor");
        }
        this.iotHubConnectionString = IotHubConnectionStringBuilder.createIotHubConnectionString(connectionString);
        this.hostName = this.iotHubConnectionString.getHostName();
        this.options = options;
        ConfigurationsClient.commonConstructorSetup();
    }

    public ConfigurationsClient(String hostName, TokenCredential credential) {
        this(hostName, credential, ConfigurationsClientOptions.builder().build());
    }

    public ConfigurationsClient(String hostName, TokenCredential credential, ConfigurationsClientOptions options) {
        Objects.requireNonNull(credential, "credential cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        this.options = options;
        this.credentialCache = new TokenCredentialCache(credential);
        this.hostName = hostName;
        ConfigurationsClient.commonConstructorSetup();
    }

    public ConfigurationsClient(String hostName, AzureSasCredential azureSasCredential) {
        this(hostName, azureSasCredential, ConfigurationsClientOptions.builder().build());
    }

    public ConfigurationsClient(String hostName, AzureSasCredential azureSasCredential, ConfigurationsClientOptions options) {
        Objects.requireNonNull(azureSasCredential, "azureSasCredential cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        this.options = options;
        this.azureSasCredential = azureSasCredential;
        this.hostName = hostName;
        ConfigurationsClient.commonConstructorSetup();
    }

    private static void commonConstructorSetup() {
        log.debug("Initialized a ConfigurationsClient instance using SDK version {}", (Object)TransportUtils.serviceVersion);
    }

    public Configuration create(Configuration configuration) throws IOException, IotHubException {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration cannot be null");
        }
        String configurationJson = configuration.toConfigurationParser().toJson();
        URL url = IotHubConnectionString.getUrlConfiguration(this.hostName, configuration.getId());
        HttpRequest request = this.createRequest(url, HttpMethod.PUT, configurationJson.getBytes(StandardCharsets.UTF_8));
        HttpResponse response = request.send();
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        return new Configuration(new ConfigurationParser(bodyStr));
    }

    public Configuration get(String configurationId) throws IOException, IotHubException {
        if (configurationId == null || configurationId.isEmpty()) {
            throw new IllegalArgumentException("configurationId cannot be null or empty");
        }
        URL url = IotHubConnectionString.getUrlConfiguration(this.hostName, configurationId);
        HttpRequest request = this.createRequest(url, HttpMethod.GET, new byte[0]);
        HttpResponse response = request.send();
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        return new Configuration(new ConfigurationParser(bodyStr));
    }

    public List<Configuration> get(int maxCount) throws IOException, IotHubException {
        if (maxCount < 1) {
            throw new IllegalArgumentException("maxCount cannot be less then 1");
        }
        URL url = IotHubConnectionString.getUrlConfigurationsList(this.hostName, maxCount);
        HttpRequest request = this.createRequest(url, HttpMethod.GET, new byte[0]);
        HttpResponse response = request.send();
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        ArrayList<Configuration> configurationList = new ArrayList<Configuration>();
        Gson gson = new Gson();
        ConfigurationParser[] configurationParsers = (ConfigurationParser[])gson.fromJson(bodyStr, ConfigurationParser[].class);
        for (int i = 0; i < configurationParsers.length; ++i) {
            configurationList.add(new Configuration(configurationParsers[i]));
        }
        return configurationList;
    }

    public Configuration replace(Configuration configuration) throws IOException, IotHubException {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration cannot be null");
        }
        URL url = IotHubConnectionString.getUrlConfiguration(this.hostName, configuration.getId());
        HttpRequest request = this.createRequest(url, HttpMethod.PUT, configuration.toConfigurationParser().toJson().getBytes(StandardCharsets.UTF_8));
        request.setHeaderField("If-Match", "*");
        HttpResponse response = request.send();
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        return new Configuration(new ConfigurationParser(bodyStr));
    }

    public void delete(String configurationId) throws IOException, IotHubException {
        this.removeConfigurationOperation(configurationId, "*");
    }

    public void delete(Configuration configuration) throws IOException, IotHubException {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration cannot be null or empty");
        }
        this.removeConfigurationOperation(configuration.getId(), configuration.getEtag());
    }

    private void removeConfigurationOperation(String configurationId, String etag) throws IOException, IotHubException {
        if (configurationId == null || configurationId.isEmpty()) {
            throw new IllegalArgumentException("configurationId cannot be null or empty");
        }
        if (etag == null || etag.isEmpty()) {
            throw new IllegalArgumentException("etag cannot be null or empty");
        }
        URL url = IotHubConnectionString.getUrlConfiguration(this.hostName, configurationId);
        HttpRequest request = this.createRequest(url, HttpMethod.DELETE, new byte[0]);
        request.setHeaderField("If-Match", etag);
        request.send();
    }

    public void applyConfigurationContentOnDevice(String deviceId, ConfigurationContent content) throws IOException, IotHubException {
        if (content == null) {
            throw new IllegalArgumentException("content cannot be null");
        }
        URL url = IotHubConnectionString.getUrlApplyConfigurationContent(this.hostName, deviceId);
        HttpRequest request = this.createRequest(url, HttpMethod.POST, content.toConfigurationContentParser().toJsonElement().toString().getBytes(StandardCharsets.UTF_8));
        request.send();
    }

    private HttpRequest createRequest(URL url, HttpMethod method, byte[] payload) throws IOException {
        Proxy proxy = null;
        if (this.options.getProxyOptions() != null) {
            proxy = this.options.getProxyOptions().getProxy();
        }
        HttpRequest request = new HttpRequest(url, method, payload, this.getAuthenticationToken(), proxy);
        request.setReadTimeoutSeconds(this.options.getHttpReadTimeoutSeconds());
        request.setConnectTimeoutSeconds(this.options.getHttpConnectTimeoutSeconds());
        return request;
    }

    private String getAuthenticationToken() {
        if (this.credentialCache != null) {
            return this.credentialCache.getTokenString();
        }
        if (this.azureSasCredential != null) {
            return this.azureSasCredential.getSignature();
        }
        return new IotHubServiceSasToken(this.iotHubConnectionString).toString();
    }
}

