/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.configurations.serializers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.service.ParserUtility;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationContentParser {
    private static final String MODULES_CONTENT_NAME = "modulesContent";
    @Expose(serialize=false)
    @SerializedName(value="modulesContent")
    private Map<String, Map<String, Object>> modulesContent;
    private static final String MODULE_CONTENT_NAME = "moduleContent";
    @Expose(serialize=false)
    @SerializedName(value="moduleContent")
    private Map<String, Object> moduleContent;
    private static final String DEVICE_CONTENT_NAME = "deviceContent";
    @Expose(serialize=false)
    @SerializedName(value="deviceContent")
    private Map<String, Object> deviceContent;
    private static final transient Gson gson = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();

    public ConfigurationContentParser() {
    }

    public ConfigurationContentParser(String json) {
        ConfigurationContentParser configurationContentParser;
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("The provided json cannot be null or empty");
        }
        try {
            configurationContentParser = (ConfigurationContentParser)gson.fromJson(json, ConfigurationContentParser.class);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException("The provided json could not be parsed");
        }
        this.modulesContent = configurationContentParser.modulesContent;
        this.moduleContent = configurationContentParser.moduleContent;
        this.deviceContent = configurationContentParser.deviceContent;
    }

    public JsonElement toJsonElement() {
        JsonObject contentJson = new JsonObject();
        if (this.modulesContent != null && this.modulesContent.size() > 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.putAll(this.modulesContent);
            contentJson.add(MODULES_CONTENT_NAME, ParserUtility.mapToJsonElement(map));
        }
        if (this.deviceContent != null && this.deviceContent.size() > 0) {
            contentJson.add(DEVICE_CONTENT_NAME, ParserUtility.mapToJsonElement(this.deviceContent));
        }
        if (this.moduleContent != null && this.moduleContent.size() > 0) {
            contentJson.add(MODULE_CONTENT_NAME, ParserUtility.mapToJsonElement(this.moduleContent));
        }
        return contentJson;
    }

    public Map<String, Map<String, Object>> getModulesContent() {
        return this.modulesContent;
    }

    public void setModulesContent(Map<String, Map<String, Object>> modulesContent) {
        this.modulesContent = modulesContent;
    }

    public Map<String, Object> getModuleContent() {
        return this.moduleContent;
    }

    public void setModuleContent(Map<String, Object> moduleContent) {
        this.moduleContent = moduleContent;
    }

    public Map<String, Object> getDeviceContent() {
        return this.deviceContent;
    }

    public void setDeviceContent(Map<String, Object> deviceContent) {
        this.deviceContent = deviceContent;
    }
}

