/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.digitaltwin.authentication;

import com.microsoft.azure.sdk.iot.service.digitaltwin.authentication.SasTokenProvider;
import com.microsoft.azure.sdk.iot.service.digitaltwin.helpers.Base64;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SasTokenProviderWithSharedAccessKey
implements SasTokenProvider {
    private static final Logger log = LoggerFactory.getLogger(SasTokenProviderWithSharedAccessKey.class);
    private static final String TOKEN_FORMAT = "SharedAccessSignature sr=%s&sig=%s&se=%s&skn=%s";
    private static final int DEFAULT_TOKEN_TIME_TO_LIVE_IN_SECS = 3600;
    private final Lock lock;
    private final String hostName;
    private final String sharedAccessKeyName;
    private final String sharedAccessKey;
    private final int timeToLiveInSecs;
    private String cachedSasToken;
    private long tokenExpiryTimeInMilliSecs;

    private SasTokenProviderWithSharedAccessKey(@NonNull String hostName, @NonNull String sharedAccessKeyName, @NonNull String sharedAccessKey, Integer timeToLiveInSecs) {
        if (hostName == null) {
            throw new NullPointerException("hostName is marked non-null but is null");
        }
        if (sharedAccessKeyName == null) {
            throw new NullPointerException("sharedAccessKeyName is marked non-null but is null");
        }
        if (sharedAccessKey == null) {
            throw new NullPointerException("sharedAccessKey is marked non-null but is null");
        }
        if (timeToLiveInSecs == null) {
            timeToLiveInSecs = 3600;
        }
        this.hostName = hostName;
        this.sharedAccessKeyName = sharedAccessKeyName;
        this.sharedAccessKey = sharedAccessKey;
        this.timeToLiveInSecs = timeToLiveInSecs;
        this.lock = new ReentrantLock();
    }

    @Override
    public String getSasToken() throws IOException {
        try {
            this.lock.lock();
            if (this.isTokenExpired()) {
                this.cachedSasToken = this.buildToken();
            }
            String string = this.cachedSasToken;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private String buildToken() throws IOException {
        log.debug("Generating new SAS token");
        long newTokenExpiryTimeInSecs = this.getTokenExpiryTimeInMilliSecs() / 1000L;
        try {
            String targetUri = URLEncoder.encode(this.hostName.toLowerCase(), StandardCharsets.UTF_8.toString());
            String toSign = targetUri + "\n" + newTokenExpiryTimeInSecs;
            byte[] keyBytes = Base64.decodeBase64Local(this.sharedAccessKey.getBytes(StandardCharsets.UTF_8));
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(toSign.getBytes(StandardCharsets.UTF_8));
            String signature = URLEncoder.encode(Base64.encodeBase64StringLocal(rawHmac), StandardCharsets.UTF_8.toString());
            String newToken = String.format(TOKEN_FORMAT, targetUri, signature, newTokenExpiryTimeInSecs, this.sharedAccessKeyName);
            this.tokenExpiryTimeInMilliSecs = newTokenExpiryTimeInSecs * 1000L;
            log.debug("Generated new SAS token");
            return newToken;
        }
        catch (Exception e) {
            throw new IOException("Generation of new SAS token failed", e);
        }
    }

    private long getTokenExpiryTimeInMilliSecs() {
        return System.currentTimeMillis() + (long)this.timeToLiveInSecs * 1000L;
    }

    private boolean isTokenExpired() {
        return this.cachedSasToken == null || this.tokenExpiryTimeInMilliSecs <= System.currentTimeMillis();
    }

    public static SasTokenProviderWithSharedAccessKeyBuilder builder() {
        return new SasTokenProviderWithSharedAccessKeyBuilder();
    }

    public static class SasTokenProviderWithSharedAccessKeyBuilder {
        private String hostName;
        private String sharedAccessKeyName;
        private String sharedAccessKey;
        private Integer timeToLiveInSecs;

        SasTokenProviderWithSharedAccessKeyBuilder() {
        }

        public SasTokenProviderWithSharedAccessKeyBuilder hostName(@NonNull String hostName) {
            if (hostName == null) {
                throw new NullPointerException("hostName is marked non-null but is null");
            }
            this.hostName = hostName;
            return this;
        }

        public SasTokenProviderWithSharedAccessKeyBuilder sharedAccessKeyName(@NonNull String sharedAccessKeyName) {
            if (sharedAccessKeyName == null) {
                throw new NullPointerException("sharedAccessKeyName is marked non-null but is null");
            }
            this.sharedAccessKeyName = sharedAccessKeyName;
            return this;
        }

        public SasTokenProviderWithSharedAccessKeyBuilder sharedAccessKey(@NonNull String sharedAccessKey) {
            if (sharedAccessKey == null) {
                throw new NullPointerException("sharedAccessKey is marked non-null but is null");
            }
            this.sharedAccessKey = sharedAccessKey;
            return this;
        }

        public SasTokenProviderWithSharedAccessKeyBuilder timeToLiveInSecs(Integer timeToLiveInSecs) {
            this.timeToLiveInSecs = timeToLiveInSecs;
            return this;
        }

        public SasTokenProviderWithSharedAccessKey build() {
            return new SasTokenProviderWithSharedAccessKey(this.hostName, this.sharedAccessKeyName, this.sharedAccessKey, this.timeToLiveInSecs);
        }

        public String toString() {
            return "SasTokenProviderWithSharedAccessKey.SasTokenProviderWithSharedAccessKeyBuilder(hostName=" + this.hostName + ", sharedAccessKeyName=" + this.sharedAccessKeyName + ", sharedAccessKey=" + this.sharedAccessKey + ", timeToLiveInSecs=" + this.timeToLiveInSecs + ")";
        }
    }
}

