/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.digitaltwin.authentication;

import com.microsoft.azure.sdk.iot.service.digitaltwin.authentication.ServiceConnectionString;
import java.util.HashMap;
import java.util.StringTokenizer;
import lombok.NonNull;

public final class ServiceConnectionStringParser {
    private static final String VALUE_PAIR_DELIMITER = ";";
    private static final String VALUE_PAIR_SEPARATOR = "=";
    private static final String HOST_NAME_PROPERTY_NAME = "HostName";
    private static final String SHARED_ACCESS_KEY_NAME_PROPERTY_NAME = "SharedAccessKeyName";
    private static final String SHARED_ACCESS_KEY_PROPERTY_NAME = "SharedAccessKey";
    private static final String SHARED_ACCESS_SIGNATURE_PROPERTY_NAME = "SharedAccessSignature";
    private static final String ENDPOINT_PROTOCOL = "https";

    private ServiceConnectionStringParser() {
    }

    public static ServiceConnectionString parseConnectionString(@NonNull String connectionString) {
        if (connectionString == null) {
            throw new NullPointerException("connectionString is marked non-null but is null");
        }
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer1 = new StringTokenizer(connectionString, VALUE_PAIR_DELIMITER);
        while (stringTokenizer1.hasMoreTokens()) {
            String currentToken = stringTokenizer1.nextToken();
            String[] splitString = currentToken.split(VALUE_PAIR_SEPARATOR, 2);
            if (splitString.length != 2) continue;
            keyValueMap.put(splitString[0], splitString[1]);
        }
        String hostName = (String)keyValueMap.get(HOST_NAME_PROPERTY_NAME);
        return ServiceConnectionString.builder().hostName(hostName).httpsEndpoint(ServiceConnectionStringParser.buildHttpsEndpoint(hostName)).sharedAccessKeyName((String)keyValueMap.get(SHARED_ACCESS_KEY_NAME_PROPERTY_NAME)).sharedAccessKey((String)keyValueMap.get(SHARED_ACCESS_KEY_PROPERTY_NAME)).sharedAccessSignature((String)keyValueMap.get(SHARED_ACCESS_SIGNATURE_PROPERTY_NAME)).build();
    }

    private static String buildHttpsEndpoint(String hostName) {
        return String.format("%s://%s", ENDPOINT_PROTOCOL, hostName);
    }
}

