/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.digitaltwin.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

public final class DigitalTwinStringSerializer
extends StdSerializer<String> {
    private static final long serialVersionUID = 1L;
    private final ObjectMapper mapper;

    public DigitalTwinStringSerializer(Class<String> t, ObjectMapper mapper) {
        super(t);
        this.mapper = mapper;
    }

    public void serialize(String s, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.isValidJson(s)) {
            jsonGenerator.writeRawValue(s);
        } else {
            jsonGenerator.writeString(s);
        }
    }

    private boolean isValidJson(String jsonInString) {
        try {
            this.mapper.readTree(jsonInString);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

