/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.jobs;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionStringBuilder;
import com.microsoft.azure.sdk.iot.service.auth.IotHubServiceSasToken;
import com.microsoft.azure.sdk.iot.service.auth.TokenCredentialCache;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.jobs.DirectMethodsJobOptions;
import com.microsoft.azure.sdk.iot.service.jobs.ScheduledJob;
import com.microsoft.azure.sdk.iot.service.jobs.ScheduledJobStatus;
import com.microsoft.azure.sdk.iot.service.jobs.ScheduledJobType;
import com.microsoft.azure.sdk.iot.service.jobs.ScheduledJobsClientOptions;
import com.microsoft.azure.sdk.iot.service.jobs.serializers.ScheduledJobParser;
import com.microsoft.azure.sdk.iot.service.methods.serializers.MethodParser;
import com.microsoft.azure.sdk.iot.service.query.JobQueryResponse;
import com.microsoft.azure.sdk.iot.service.query.QueryClient;
import com.microsoft.azure.sdk.iot.service.query.QueryClientOptions;
import com.microsoft.azure.sdk.iot.service.query.QueryPageOptions;
import com.microsoft.azure.sdk.iot.service.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpMethod;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpRequest;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpResponse;
import com.microsoft.azure.sdk.iot.service.twin.Twin;
import com.microsoft.azure.sdk.iot.service.twin.TwinCollection;
import com.microsoft.azure.sdk.iot.service.twin.TwinState;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScheduledJobsClient {
    private static final Logger log = LoggerFactory.getLogger(ScheduledJobsClient.class);
    private static final byte[] EMPTY_JSON = "{}".getBytes(StandardCharsets.UTF_8);
    private final String hostName;
    private TokenCredentialCache credentialCache;
    private AzureSasCredential azureSasCredential;
    private IotHubConnectionString iotHubConnectionString;
    private final ScheduledJobsClientOptions clientOptions;
    private final QueryClient queryClient;

    public ScheduledJobsClient(String connectionString) {
        this(connectionString, ScheduledJobsClientOptions.builder().build());
    }

    public ScheduledJobsClient(String connectionString, ScheduledJobsClientOptions clientOptions) {
        Objects.requireNonNull(clientOptions);
        if (connectionString == null || connectionString.isEmpty()) {
            throw new IllegalArgumentException("connection string cannot be null or empty");
        }
        this.iotHubConnectionString = IotHubConnectionStringBuilder.createIotHubConnectionString(connectionString);
        this.hostName = this.iotHubConnectionString.getHostName();
        this.clientOptions = clientOptions;
        ScheduledJobsClient.commonConstructorSetup();
        QueryClientOptions queryClientOptions = QueryClientOptions.builder().httpReadTimeoutSeconds(clientOptions.getHttpReadTimeoutSeconds()).httpConnectTimeoutSeconds(clientOptions.getHttpConnectTimeoutSeconds()).proxyOptions(clientOptions.getProxyOptions()).build();
        this.queryClient = new QueryClient(connectionString, queryClientOptions);
    }

    public ScheduledJobsClient(String hostName, TokenCredential credential) {
        this(hostName, credential, ScheduledJobsClientOptions.builder().build());
    }

    public ScheduledJobsClient(String hostName, TokenCredential credential, ScheduledJobsClientOptions clientOptions) {
        Objects.requireNonNull(credential);
        Objects.requireNonNull(clientOptions);
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        this.hostName = hostName;
        this.credentialCache = new TokenCredentialCache(credential);
        this.clientOptions = clientOptions;
        ScheduledJobsClient.commonConstructorSetup();
        QueryClientOptions queryClientOptions = QueryClientOptions.builder().httpReadTimeoutSeconds(clientOptions.getHttpReadTimeoutSeconds()).httpConnectTimeoutSeconds(clientOptions.getHttpConnectTimeoutSeconds()).proxyOptions(clientOptions.getProxyOptions()).build();
        this.queryClient = new QueryClient(hostName, credential, queryClientOptions);
    }

    public ScheduledJobsClient(String hostName, AzureSasCredential azureSasCredential) {
        this(hostName, azureSasCredential, ScheduledJobsClientOptions.builder().build());
    }

    public ScheduledJobsClient(String hostName, AzureSasCredential azureSasCredential, ScheduledJobsClientOptions clientOptions) {
        Objects.requireNonNull(azureSasCredential);
        Objects.requireNonNull(clientOptions);
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        this.hostName = hostName;
        this.azureSasCredential = azureSasCredential;
        this.clientOptions = clientOptions;
        ScheduledJobsClient.commonConstructorSetup();
        QueryClientOptions queryClientOptions = QueryClientOptions.builder().httpReadTimeoutSeconds(clientOptions.getHttpReadTimeoutSeconds()).httpConnectTimeoutSeconds(clientOptions.getHttpConnectTimeoutSeconds()).proxyOptions(clientOptions.getProxyOptions()).build();
        this.queryClient = new QueryClient(hostName, azureSasCredential, queryClientOptions);
    }

    private static void commonConstructorSetup() {
        log.debug("Initialized a ScheduledJobsClient instance using SDK version {}", (Object)TransportUtils.serviceVersion);
    }

    public ScheduledJob scheduleUpdateTwin(String jobId, String queryCondition, Twin updateTwin, Date startTimeUtc, long maxExecutionTimeInSeconds) throws IOException, IotHubException {
        URL url;
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("jobId cannot be null or empty");
        }
        if (updateTwin == null) {
            throw new IllegalArgumentException("updateTwin cannot be null");
        }
        if (startTimeUtc == null) {
            throw new IllegalArgumentException("startTimeUtc cannot be null");
        }
        if (maxExecutionTimeInSeconds < 0L) {
            throw new IllegalArgumentException("maxExecutionTimeSeconds cannot be negative");
        }
        ScheduledJobParser jobsParser = new ScheduledJobParser(jobId, this.getParserFromDevice(updateTwin), queryCondition, startTimeUtc, maxExecutionTimeInSeconds);
        String json = jobsParser.toJson();
        try {
            url = IotHubConnectionString.getUrlJobs(this.hostName, jobId);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid JobId to create url");
        }
        HttpRequest httpRequest = this.createRequest(url, HttpMethod.PUT, json.getBytes(StandardCharsets.UTF_8));
        HttpResponse response = httpRequest.send();
        return new ScheduledJob(new String(response.getBody(), StandardCharsets.UTF_8));
    }

    public ScheduledJob scheduleDirectMethod(String jobId, String queryCondition, String methodName, Date startTimeUtc) throws IOException, IotHubException {
        return this.scheduleDirectMethod(jobId, queryCondition, methodName, startTimeUtc, DirectMethodsJobOptions.builder().build());
    }

    public ScheduledJob scheduleDirectMethod(String jobId, String queryCondition, String methodName, Date startTimeUtc, DirectMethodsJobOptions options) throws IOException, IotHubException {
        URL url;
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("jobId cannot be null or empty");
        }
        if (methodName == null || methodName.isEmpty()) {
            throw new IllegalArgumentException("method name cannot be null or empty");
        }
        if (startTimeUtc == null) {
            throw new IllegalArgumentException("startTimeUtc cannot be null");
        }
        Objects.requireNonNull(options);
        if (options.getMaxExecutionTimeSeconds() < 0) {
            throw new IllegalArgumentException("maxExecutionTimeSeconds cannot be less than 0");
        }
        MethodParser cloudToDeviceMethod = new MethodParser(methodName, options.getMethodResponseTimeoutSeconds(), options.getMethodConnectTimeoutSeconds(), options.getPayload());
        ScheduledJobParser jobsParser = new ScheduledJobParser(jobId, cloudToDeviceMethod, queryCondition, startTimeUtc, (long)options.getMaxExecutionTimeSeconds());
        String json = jobsParser.toJson();
        try {
            url = IotHubConnectionString.getUrlJobs(this.hostName, jobId);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid JobId to create url");
        }
        HttpRequest httpRequest = this.createRequest(url, HttpMethod.PUT, json.getBytes(StandardCharsets.UTF_8));
        HttpResponse response = httpRequest.send();
        return new ScheduledJob(new String(response.getBody(), StandardCharsets.UTF_8));
    }

    public ScheduledJob get(String jobId) throws IOException, IotHubException {
        URL url;
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("jobId cannot be null or empty");
        }
        try {
            url = IotHubConnectionString.getUrlJobs(this.hostName, jobId);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid JobId to create url");
        }
        HttpRequest httpRequest = this.createRequest(url, HttpMethod.GET, new byte[0]);
        HttpResponse response = httpRequest.send();
        return new ScheduledJob(new String(response.getBody(), StandardCharsets.UTF_8));
    }

    public ScheduledJob cancel(String jobId) throws IOException, IotHubException {
        URL url;
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("jobId cannot be null or empty");
        }
        try {
            url = IotHubConnectionString.getUrlJobsCancel(this.hostName, jobId);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid JobId to create url");
        }
        HttpRequest httpRequest = this.createRequest(url, HttpMethod.POST, EMPTY_JSON);
        HttpResponse response = httpRequest.send();
        return new ScheduledJob(new String(response.getBody(), StandardCharsets.UTF_8));
    }

    public JobQueryResponse query(String query) throws IOException, IotHubException {
        return this.queryClient.queryJobs(query);
    }

    public JobQueryResponse query(String query, QueryPageOptions options) throws IOException, IotHubException {
        return this.queryClient.queryJobs(query, options);
    }

    public JobQueryResponse query(ScheduledJobType jobType, ScheduledJobStatus jobStatus) throws IOException, IotHubException {
        return this.queryClient.queryJobs(jobType, jobStatus);
    }

    public JobQueryResponse query(ScheduledJobType jobType, ScheduledJobStatus jobStatus, QueryPageOptions options) throws IOException, IotHubException {
        return this.queryClient.queryJobs(jobType, jobStatus, options);
    }

    private TwinState getParserFromDevice(Twin device) {
        TwinCollection tags = null;
        TwinCollection desired = null;
        TwinCollection reported = null;
        if (device.getTags() != null) {
            tags = device.getTags();
        }
        if (device.getDesiredProperties() != null) {
            desired = device.getDesiredProperties();
        }
        if (device.getReportedProperties() != null) {
            reported = device.getReportedProperties();
        }
        TwinState twinState = new TwinState(tags, desired, reported);
        if (device.getDeviceId() != null) {
            twinState.setDeviceId(device.getDeviceId());
        }
        if (device.getETag() == null) {
            twinState.setETag("*");
        } else {
            twinState.setETag(device.getETag());
        }
        return twinState;
    }

    private String getAuthenticationToken() {
        if (this.credentialCache != null) {
            return this.credentialCache.getTokenString();
        }
        if (this.azureSasCredential != null) {
            return this.azureSasCredential.getSignature();
        }
        return new IotHubServiceSasToken(this.iotHubConnectionString).toString();
    }

    private HttpRequest createRequest(URL url, HttpMethod method, byte[] payload) throws IOException {
        Proxy proxy = null;
        if (this.clientOptions.getProxyOptions() != null) {
            proxy = this.clientOptions.getProxyOptions().getProxy();
        }
        HttpRequest request = new HttpRequest(url, method, payload, this.getAuthenticationToken(), proxy);
        request.setReadTimeoutSeconds(this.clientOptions.getHttpReadTimeoutSeconds());
        request.setConnectTimeoutSeconds(this.clientOptions.getHttpConnectTimeoutSeconds());
        return request;
    }
}

