/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.messaging;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionStringBuilder;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.messaging.AcknowledgementType;
import com.microsoft.azure.sdk.iot.service.messaging.ErrorContext;
import com.microsoft.azure.sdk.iot.service.messaging.FileUploadNotification;
import com.microsoft.azure.sdk.iot.service.messaging.FileUploadNotificationProcessorClientOptions;
import com.microsoft.azure.sdk.iot.service.messaging.IotHubServiceClientProtocol;
import com.microsoft.azure.sdk.iot.service.transport.amqps.EventReceivingConnectionHandler;
import com.microsoft.azure.sdk.iot.service.transport.amqps.ReactorRunner;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadNotificationProcessorClient {
    private static final Logger log = LoggerFactory.getLogger(FileUploadNotificationProcessorClient.class);
    private static final int START_REACTOR_TIMEOUT_MILLISECONDS = 60000;
    private static final int STOP_REACTOR_TIMEOUT_MILLISECONDS = 5000;
    private final EventReceivingConnectionHandler eventReceivingConnectionHandler;
    private final Consumer<ErrorContext> errorProcessor;
    private ReactorRunner reactorRunner;
    private final String hostName;

    public FileUploadNotificationProcessorClient(String hostName, TokenCredential credential, IotHubServiceClientProtocol protocol, Function<FileUploadNotification, AcknowledgementType> fileUploadNotificationProcessor) {
        this(hostName, credential, protocol, fileUploadNotificationProcessor, FileUploadNotificationProcessorClientOptions.builder().build());
    }

    public FileUploadNotificationProcessorClient(String hostName, TokenCredential credential, IotHubServiceClientProtocol protocol, Function<FileUploadNotification, AcknowledgementType> fileUploadNotificationProcessor, FileUploadNotificationProcessorClientOptions options) {
        Objects.requireNonNull(options, "Options cannot be null");
        this.errorProcessor = options.getErrorProcessor();
        this.hostName = hostName;
        this.eventReceivingConnectionHandler = new EventReceivingConnectionHandler(hostName, credential, protocol, fileUploadNotificationProcessor, null, this.errorProcessor, options.getProxyOptions(), options.getSslContext(), options.getKeepAliveInterval());
    }

    public FileUploadNotificationProcessorClient(String hostName, AzureSasCredential azureSasCredential, IotHubServiceClientProtocol protocol, Function<FileUploadNotification, AcknowledgementType> fileUploadNotificationProcessor) {
        this(hostName, azureSasCredential, protocol, fileUploadNotificationProcessor, FileUploadNotificationProcessorClientOptions.builder().build());
    }

    public FileUploadNotificationProcessorClient(String hostName, AzureSasCredential azureSasCredential, IotHubServiceClientProtocol protocol, Function<FileUploadNotification, AcknowledgementType> fileUploadNotificationProcessor, FileUploadNotificationProcessorClientOptions options) {
        Objects.requireNonNull(options, "Options cannot be null");
        this.errorProcessor = options.getErrorProcessor();
        this.hostName = hostName;
        this.eventReceivingConnectionHandler = new EventReceivingConnectionHandler(hostName, azureSasCredential, protocol, fileUploadNotificationProcessor, null, this.errorProcessor, options.getProxyOptions(), options.getSslContext(), options.getKeepAliveInterval());
    }

    public FileUploadNotificationProcessorClient(String connectionString, IotHubServiceClientProtocol protocol, Function<FileUploadNotification, AcknowledgementType> fileUploadNotificationProcessor) {
        this(connectionString, protocol, fileUploadNotificationProcessor, FileUploadNotificationProcessorClientOptions.builder().build());
    }

    public FileUploadNotificationProcessorClient(String connectionString, IotHubServiceClientProtocol protocol, Function<FileUploadNotification, AcknowledgementType> fileUploadNotificationProcessor, FileUploadNotificationProcessorClientOptions options) {
        Objects.requireNonNull(options, "Options cannot be null");
        if (connectionString == null || connectionString.isEmpty()) {
            throw new IllegalArgumentException("Connection string cannot be null or empty");
        }
        this.errorProcessor = options.getErrorProcessor();
        this.hostName = IotHubConnectionStringBuilder.createIotHubConnectionString(connectionString).getHostName();
        this.eventReceivingConnectionHandler = new EventReceivingConnectionHandler(connectionString, protocol, fileUploadNotificationProcessor, null, this.errorProcessor, options.getProxyOptions(), options.getSslContext(), options.getKeepAliveInterval());
    }

    public synchronized void start() throws IotHubException, IOException, InterruptedException, TimeoutException {
        this.start(60000);
    }

    public synchronized void start(int timeoutMilliseconds) throws IotHubException, IOException, InterruptedException, TimeoutException {
        if (this.isRunning()) {
            return;
        }
        if (timeoutMilliseconds < 0) {
            throw new IllegalArgumentException("timeoutMilliseconds must be greater than or equal to 0");
        }
        AtomicReference<Object> iotHubException = new AtomicReference<Object>(null);
        AtomicReference<Object> ioException = new AtomicReference<Object>(null);
        log.debug("Opening FileUploadNotificationProcessorClient");
        this.reactorRunner = new ReactorRunner(this.hostName, "FileUploadNotificationProcessor", this.eventReceivingConnectionHandler);
        CountDownLatch openLatch = new CountDownLatch(1);
        this.eventReceivingConnectionHandler.setOnConnectionOpenedCallback(openLatch::countDown);
        new Thread(() -> {
            try {
                this.reactorRunner.run();
                log.trace("FileUploadNotificationProcessorClient Amqp reactor stopped, checking that the connection was opened");
                this.eventReceivingConnectionHandler.verifyConnectionWasOpened();
                log.trace("FileUploadNotificationProcessorClient  reactor did successfully open the connection, returning without exception");
            }
            catch (IOException e) {
                ioException.set(e);
            }
            catch (IotHubException e) {
                iotHubException.set(e);
            }
            finally {
                openLatch.countDown();
            }
        }).start();
        if (timeoutMilliseconds == 0) {
            openLatch.await();
        } else {
            boolean timedOut;
            boolean bl = timedOut = !openLatch.await(timeoutMilliseconds, TimeUnit.MILLISECONDS);
            if (timedOut) {
                throw new TimeoutException("Timed out waiting for the connection to the service to open");
            }
        }
        if (ioException.get() != null) {
            throw (IOException)ioException.get();
        }
        if (iotHubException.get() != null) {
            throw (IotHubException)iotHubException.get();
        }
        log.info("Started FileUploadNotificationProcessorClient");
    }

    public synchronized void stop() throws InterruptedException {
        this.stop(5000);
    }

    public synchronized void stop(int timeoutMilliseconds) throws InterruptedException {
        if (this.reactorRunner == null) {
            return;
        }
        this.reactorRunner.stop(timeoutMilliseconds);
        this.reactorRunner = null;
        log.info("Stopped FileUploadNotificationProcessorClient");
    }

    public synchronized boolean isRunning() {
        return this.reactorRunner != null && this.reactorRunner.isRunning();
    }
}

