/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.messaging;

import com.microsoft.azure.sdk.iot.service.messaging.DeliveryAcknowledgement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Message {
    private static final String deliveryAcknowledgementPropertyName = "iothub-ack";
    public static final Charset DEFAULT_IOTHUB_MESSAGE_CHARSET = StandardCharsets.UTF_8;
    private String messageId;
    private String to;
    private Date expiryTimeUtc;
    private String lockToken;
    private String correlationId;
    private String userId;
    private DeliveryAcknowledgement deliveryAcknowledgement;
    private final Map<String, String> properties = new HashMap<String, String>(1);
    private byte[] body;

    public void setTo(String deviceId) {
        this.to = "/devices/" + deviceId + "/messages/devicebound";
    }

    public Message() {
        this.setDeliveryAcknowledgement(DeliveryAcknowledgement.Full);
        this.correlationId = UUID.randomUUID().toString();
    }

    public Message(ByteArrayInputStream stream) {
        this();
        if (stream != null) {
            this.body = stream.toString().getBytes(StandardCharsets.UTF_8);
        }
    }

    public Message(byte[] byteArray) {
        this();
        if (byteArray == null) {
            throw new IllegalArgumentException("Message body cannot be 'null'.");
        }
        this.body = byteArray;
    }

    public Message(String string) {
        this();
        this.body = string.getBytes(StandardCharsets.UTF_8);
    }

    public ByteArrayOutputStream getBodyStream() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.body.length);
        byteArrayOutputStream.write(this.body, 0, this.body.length);
        return byteArrayOutputStream;
    }

    public byte[] getBytes() {
        return this.body;
    }

    public final void setDeliveryAcknowledgement(DeliveryAcknowledgement deliveryAcknowledgement) {
        this.deliveryAcknowledgement = deliveryAcknowledgement;
        this.properties.put(deliveryAcknowledgementPropertyName, deliveryAcknowledgement.name().toLowerCase());
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    public void clearCustomProperties() {
        this.properties.clear();
        this.setDeliveryAcknowledgement(this.deliveryAcknowledgement);
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getTo() {
        return this.to;
    }

    public Date getExpiryTimeUtc() {
        return this.expiryTimeUtc;
    }

    public void setExpiryTimeUtc(Date expiryTimeUtc) {
        this.expiryTimeUtc = expiryTimeUtc;
    }

    public String getLockToken() {
        return this.lockToken;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public DeliveryAcknowledgement getDeliveryAcknowledgement() {
        return this.deliveryAcknowledgement;
    }
}

