/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.methods;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.google.gson.GsonBuilder;
import com.microsoft.azure.sdk.iot.service.ProxyOptions;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.auth.IotHubConnectionStringBuilder;
import com.microsoft.azure.sdk.iot.service.auth.IotHubServiceSasToken;
import com.microsoft.azure.sdk.iot.service.auth.TokenCredentialCache;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.methods.DirectMethodRequestOptions;
import com.microsoft.azure.sdk.iot.service.methods.DirectMethodResponse;
import com.microsoft.azure.sdk.iot.service.methods.DirectMethodsClientOptions;
import com.microsoft.azure.sdk.iot.service.methods.serializers.MethodParser;
import com.microsoft.azure.sdk.iot.service.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpMethod;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpRequest;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpResponse;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DirectMethodsClient {
    private static final Logger log = LoggerFactory.getLogger(DirectMethodsClient.class);
    private Integer requestId = 0;
    private final DirectMethodsClientOptions options;
    private final String hostName;
    private TokenCredentialCache credentialCache;
    private AzureSasCredential azureSasCredential;
    private IotHubConnectionString iotHubConnectionString;

    public DirectMethodsClient(String connectionString) {
        this(connectionString, DirectMethodsClientOptions.builder().build());
    }

    public DirectMethodsClient(String connectionString, DirectMethodsClientOptions options) {
        Objects.requireNonNull(options);
        if (connectionString == null || connectionString.isEmpty()) {
            throw new IllegalArgumentException("Connection string cannot be null or empty");
        }
        this.hostName = IotHubConnectionStringBuilder.createIotHubConnectionString(connectionString).getHostName();
        this.options = options;
        this.iotHubConnectionString = IotHubConnectionStringBuilder.createIotHubConnectionString(connectionString);
        DirectMethodsClient.commonConstructorSetup();
    }

    public DirectMethodsClient(String hostName, TokenCredential credential) {
        this(hostName, credential, DirectMethodsClientOptions.builder().build());
    }

    public DirectMethodsClient(String hostName, TokenCredential credential, DirectMethodsClientOptions options) {
        Objects.requireNonNull(credential, "TokenCredential cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        this.options = options;
        this.credentialCache = new TokenCredentialCache(credential);
        this.hostName = hostName;
        DirectMethodsClient.commonConstructorSetup();
    }

    public DirectMethodsClient(String hostName, AzureSasCredential azureSasCredential) {
        this(hostName, azureSasCredential, DirectMethodsClientOptions.builder().build());
    }

    public DirectMethodsClient(String hostName, AzureSasCredential azureSasCredential, DirectMethodsClientOptions options) {
        Objects.requireNonNull(azureSasCredential, "azureSasCredential cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        this.options = options;
        this.azureSasCredential = azureSasCredential;
        this.hostName = hostName;
        DirectMethodsClient.commonConstructorSetup();
    }

    private static void commonConstructorSetup() {
        log.debug("Initialized a DirectMethodsClient instance using SDK version {}", (Object)TransportUtils.serviceVersion);
    }

    public DirectMethodResponse invoke(String deviceId, String methodName) throws IotHubException, IOException {
        return this.invoke(deviceId, methodName, DirectMethodRequestOptions.builder().build());
    }

    public DirectMethodResponse invoke(String deviceId, String methodName, DirectMethodRequestOptions options) throws IotHubException, IOException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("deviceId is empty or null.");
        }
        if (methodName == null || methodName.isEmpty()) {
            throw new IllegalArgumentException("methodName is empty or null.");
        }
        Objects.requireNonNull(options);
        URL url = IotHubConnectionString.getUrlMethod(this.hostName, deviceId);
        return this.invokeMethod(url, methodName, options);
    }

    public DirectMethodResponse invoke(String deviceId, String moduleId, String methodName) throws IotHubException, IOException {
        return this.invoke(deviceId, moduleId, methodName, DirectMethodRequestOptions.builder().build());
    }

    public DirectMethodResponse invoke(String deviceId, String moduleId, String methodName, DirectMethodRequestOptions options) throws IotHubException, IOException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("deviceId is empty or null.");
        }
        if (moduleId == null || moduleId.isEmpty()) {
            throw new IllegalArgumentException("moduleId is empty or null.");
        }
        if (methodName == null || methodName.isEmpty()) {
            throw new IllegalArgumentException("methodName is empty or null.");
        }
        Objects.requireNonNull(options);
        URL url = IotHubConnectionString.getUrlModuleMethod(this.hostName, deviceId, moduleId);
        return this.invokeMethod(url, methodName, options);
    }

    private DirectMethodResponse invokeMethod(URL url, String methodName, DirectMethodRequestOptions options) throws IotHubException, IOException {
        MethodParser methodParser = new MethodParser(methodName, options.getMethodResponseTimeoutSeconds(), options.getMethodConnectTimeoutSeconds(), options.getPayload());
        String json = methodParser.toJson();
        if (json == null) {
            throw new IllegalArgumentException("MethodParser return null Json");
        }
        ProxyOptions proxyOptions = this.options.getProxyOptions();
        Proxy proxy = proxyOptions != null ? proxyOptions.getProxy() : null;
        HttpRequest httpRequest = new HttpRequest(url, HttpMethod.POST, json.getBytes(StandardCharsets.UTF_8), this.getAuthenticationToken(), proxy);
        httpRequest.setReadTimeoutSeconds(this.options.getHttpReadTimeoutSeconds());
        httpRequest.setConnectTimeoutSeconds(this.options.getHttpConnectTimeoutSeconds());
        Integer n = this.requestId;
        Integer n2 = this.requestId = Integer.valueOf(this.requestId + 1);
        httpRequest.setHeaderField("Request-Id", String.valueOf(n));
        HttpResponse response = httpRequest.send();
        MethodParser methodParserResponse = new MethodParser();
        methodParserResponse.fromJson(new String(response.getBody(), StandardCharsets.UTF_8));
        return new DirectMethodResponse(methodParserResponse.getStatus(), new GsonBuilder().create().toJsonTree(methodParserResponse.getPayload()));
    }

    private String getAuthenticationToken() {
        if (this.credentialCache != null) {
            return this.credentialCache.getTokenString();
        }
        if (this.azureSasCredential != null) {
            return this.azureSasCredential.getSignature();
        }
        return new IotHubServiceSasToken(this.iotHubConnectionString).toString();
    }
}

