/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.methods.serializers;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.service.ParserUtility;

public class MethodParser {
    @Expose(serialize=false, deserialize=false)
    private Operation operation = Operation.none;
    private static final String METHOD_NAME_TAG = "methodName";
    @Expose(deserialize=false)
    @SerializedName(value="methodName")
    private String name = null;
    private static final String RESPONSE_TIMEOUT_IN_SECONDS_TAG = "responseTimeoutInSeconds";
    @Expose(deserialize=false)
    @SerializedName(value="responseTimeoutInSeconds")
    private int responseTimeout = 0;
    private static final String CONNECT_TIMEOUT_IN_SECONDS_TAG = "connectTimeoutInSeconds";
    @Expose(deserialize=false)
    @SerializedName(value="connectTimeoutInSeconds")
    private int connectTimeout = 0;
    private static final String STATUS_TAG = "status";
    @Expose(serialize=false)
    @SerializedName(value="status")
    private Integer status = null;
    private static final String PAYLOAD_TAG = "payload";
    @SerializedName(value="payload")
    private Object payload = null;

    public MethodParser() {
    }

    public MethodParser(String name, int responseTimeout, int connectTimeout, Object payload) throws IllegalArgumentException {
        this();
        this.validateKey(name);
        this.validateTimeout(responseTimeout);
        this.validateTimeout(connectTimeout);
        this.name = name;
        this.responseTimeout = responseTimeout;
        this.connectTimeout = connectTimeout;
        this.payload = payload;
        this.operation = Operation.invoke;
    }

    public MethodParser(Object payload) {
        this();
        this.payload = payload;
        this.operation = Operation.payload;
    }

    public synchronized void fromJson(String json) throws IllegalArgumentException {
        block14: {
            if (json == null || json.isEmpty()) {
                throw new IllegalArgumentException("Invalid json.");
            }
            JsonParser jsonParser = new JsonParser();
            try {
                JsonElement jsonElement = jsonParser.parse(json);
                if (jsonElement instanceof JsonPrimitive || jsonElement instanceof JsonArray) {
                    this.operation = Operation.payload;
                    this.payload = ParserUtility.resolveJsonElement(jsonElement);
                    break block14;
                }
                if (jsonElement instanceof JsonObject) {
                    JsonObject jsonObject = (JsonObject)jsonElement;
                    JsonElement statusTagNode = jsonObject.get(STATUS_TAG);
                    JsonElement methodNameNode = jsonObject.get(METHOD_NAME_TAG);
                    if (methodNameNode == null) {
                        if (statusTagNode == null) {
                            this.operation = Operation.payload;
                            this.payload = ParserUtility.getJsonObjectValue(jsonObject);
                        } else {
                            JsonElement payloadNode;
                            this.operation = Operation.response;
                            if (statusTagNode.isJsonPrimitive()) {
                                this.status = statusTagNode.getAsInt();
                            }
                            if ((payloadNode = jsonObject.get(PAYLOAD_TAG)) != null) {
                                this.payload = ParserUtility.resolveJsonElement(payloadNode);
                            }
                        }
                        break block14;
                    }
                    if (statusTagNode == null) {
                        JsonElement payloadNode;
                        JsonElement connetionTimeoutNode;
                        this.operation = Operation.invoke;
                        this.name = methodNameNode.getAsString();
                        JsonElement responseTimeoutNode = jsonObject.get(RESPONSE_TIMEOUT_IN_SECONDS_TAG);
                        if (responseTimeoutNode != null) {
                            this.responseTimeout = responseTimeoutNode.getAsInt();
                        }
                        if ((connetionTimeoutNode = jsonObject.get(CONNECT_TIMEOUT_IN_SECONDS_TAG)) != null) {
                            this.connectTimeout = connetionTimeoutNode.getAsInt();
                        }
                        if ((payloadNode = jsonObject.get(PAYLOAD_TAG)) != null) {
                            this.payload = ParserUtility.resolveJsonElement(payloadNode);
                        }
                        break block14;
                    }
                    throw new IllegalArgumentException("Invoke method name and Status reported in the same json");
                }
                throw new IllegalArgumentException("Invalid json.");
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Malformed json.", ex);
            }
        }
    }

    public Object getPayload() {
        return this.payload;
    }

    public String toJson() throws IllegalArgumentException {
        return this.toJsonElement().toString();
    }

    private JsonElement jsonizePayload(Object payload) {
        return new GsonBuilder().create().toJsonTree(payload);
    }

    public JsonElement toJsonElement() throws IllegalArgumentException {
        if (this.operation == Operation.invoke) {
            if (this.name == null || this.name.isEmpty()) {
                throw new IllegalArgumentException("cannot invoke method with null name");
            }
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(METHOD_NAME_TAG, this.name);
            if (this.responseTimeout != 0) {
                jsonObject.addProperty(RESPONSE_TIMEOUT_IN_SECONDS_TAG, (Number)this.responseTimeout);
            }
            if (this.connectTimeout != 0) {
                jsonObject.addProperty(CONNECT_TIMEOUT_IN_SECONDS_TAG, (Number)this.connectTimeout);
            }
            jsonObject.add(PAYLOAD_TAG, this.jsonizePayload(this.payload));
            return jsonObject;
        }
        if (this.operation == Operation.response) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(STATUS_TAG, (Number)this.status);
            jsonObject.add(PAYLOAD_TAG, this.jsonizePayload(this.payload));
            return jsonObject;
        }
        if (this.operation == Operation.payload) {
            return this.jsonizePayload(this.payload);
        }
        throw new IllegalArgumentException("There is no content to parser");
    }

    private void validateKey(String key) throws IllegalArgumentException {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
        if (key.length() > 128) {
            throw new IllegalArgumentException("Key cannot be longer than 128 characters");
        }
        if (key.contains("$") || key.contains(".") || key.contains(" ")) {
            throw new IllegalArgumentException("Key cannot contain '$', '.', or space");
        }
    }

    private void validateTimeout(int timeout) throws IllegalArgumentException {
        if (timeout < 0) {
            throw new IllegalArgumentException("Negative timeout");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(int responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }

    protected static enum Operation {
        invoke,
        response,
        payload,
        none;

    }
}

