/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.query;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.jobs.ScheduledJob;
import com.microsoft.azure.sdk.iot.service.jobs.ScheduledJobStatus;
import com.microsoft.azure.sdk.iot.service.jobs.ScheduledJobType;
import com.microsoft.azure.sdk.iot.service.query.QueryClient;
import com.microsoft.azure.sdk.iot.service.query.QueryPageOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class JobQueryResponse {
    private final transient Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    Iterator<ScheduledJob> jobs;
    String continuationToken = "";
    final QueryClient queryClient;
    final String originalQuery;
    final ScheduledJobType jobType;
    final ScheduledJobStatus jobStatus;

    JobQueryResponse(String json, QueryClient queryClient, String originalQuery) {
        JsonObject[] twinJsonArray = (JsonObject[])this.gson.fromJson(json, JsonObject[].class);
        ArrayList<ScheduledJob> jobsArray = new ArrayList<ScheduledJob>();
        for (JsonObject twinJson : twinJsonArray) {
            jobsArray.add(new ScheduledJob(twinJson.toString()));
        }
        this.jobs = jobsArray.iterator();
        this.queryClient = queryClient;
        this.originalQuery = originalQuery;
        this.jobType = null;
        this.jobStatus = null;
    }

    JobQueryResponse(String json, QueryClient queryClient, ScheduledJobType jobType, ScheduledJobStatus jobStatus) {
        JsonObject[] twinJsonArray = (JsonObject[])this.gson.fromJson(json, JsonObject[].class);
        ArrayList<ScheduledJob> jobsArray = new ArrayList<ScheduledJob>();
        for (JsonObject twinJson : twinJsonArray) {
            jobsArray.add(new ScheduledJob(twinJson.toString()));
        }
        this.jobs = jobsArray.iterator();
        this.queryClient = queryClient;
        this.originalQuery = null;
        this.jobType = jobType;
        this.jobStatus = jobStatus;
    }

    public boolean hasNext() {
        return this.jobs.hasNext() || this.continuationToken != null;
    }

    public ScheduledJob next() throws IotHubException, IOException, NoSuchElementException {
        return this.next(QueryPageOptions.builder().build());
    }

    public ScheduledJob next(QueryPageOptions pageOptions) throws IotHubException, IOException, NoSuchElementException {
        Objects.requireNonNull(pageOptions);
        try {
            return this.jobs.next();
        }
        catch (NoSuchElementException ex) {
            if (this.continuationToken == null) {
                throw ex;
            }
            QueryPageOptions nextPageOptions = QueryPageOptions.builder().continuationToken(this.continuationToken).pageSize(pageOptions.getPageSize()).build();
            JobQueryResponse nextPage = this.originalQuery != null ? this.queryClient.queryJobs(this.originalQuery, nextPageOptions) : this.queryClient.queryJobs(this.jobType, this.jobStatus, nextPageOptions);
            this.jobs = nextPage.jobs;
            this.continuationToken = nextPage.continuationToken;
            return this.jobs.next();
        }
    }

    void setContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }
}

