/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.query;

public class SqlQueryBuilder {
    private static final String SPACE = " ";
    private static final String SELECT = "select ";
    private static final String FROM = "from ";
    private static final String WHERE = "where ";
    private static final String GROUP_BY = "group by ";
    private final StringBuilder query = new StringBuilder();

    private SqlQueryBuilder() {
    }

    public static String createSqlQuery(String selection, FromType fromType, String where, String groupby) {
        if (selection == null || fromType == null) {
            throw new IllegalArgumentException("selection and from are mandatory");
        }
        SqlQueryBuilder sqlQuery = new SqlQueryBuilder();
        sqlQuery.query.append(SELECT).append(selection).append(SPACE).append(FROM).append(fromType.getValue()).append(SPACE);
        if (where != null && where.length() > 0) {
            sqlQuery.query.append(WHERE).append(where).append(SPACE);
        }
        if (groupby != null && groupby.length() > 0) {
            sqlQuery.query.append(GROUP_BY).append(groupby);
        }
        return sqlQuery.query.toString();
    }

    public static enum FromType {
        DEVICES("devices"),
        MODULES("devices.modules"),
        JOBS("devices.jobs");

        private final String type;

        private FromType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.type;
        }
    }
}

