/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.query;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.query.QueryClient;
import com.microsoft.azure.sdk.iot.service.query.QueryPageOptions;
import com.microsoft.azure.sdk.iot.service.twin.Twin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class TwinQueryResponse {
    private final transient Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    Iterator<Twin> twins;
    String continuationToken = "";
    final QueryClient queryClient;
    final String originalQuery;

    public TwinQueryResponse(String json, QueryClient queryClient, String originalQuery) {
        try {
            JsonObject[] twinJsonArray = (JsonObject[])this.gson.fromJson(json, JsonObject[].class);
            ArrayList<Twin> twinArray = new ArrayList<Twin>();
            for (JsonObject twinJson : twinJsonArray) {
                twinArray.add(Twin.fromJson(twinJson.toString()));
            }
            this.twins = twinArray.iterator();
        }
        catch (JsonSyntaxException malformed) {
            throw new IllegalArgumentException("Malformed json:" + (Object)((Object)malformed));
        }
        this.queryClient = queryClient;
        this.originalQuery = originalQuery;
    }

    public boolean hasNext() {
        return this.twins.hasNext() || this.continuationToken != null;
    }

    public Twin next() throws IotHubException, IOException {
        return this.next(QueryPageOptions.builder().build());
    }

    public Twin next(QueryPageOptions pageOptions) throws IotHubException, IOException, NoSuchElementException {
        Objects.requireNonNull(pageOptions);
        try {
            return this.twins.next();
        }
        catch (NoSuchElementException ex) {
            if (this.continuationToken == null) {
                throw ex;
            }
            QueryPageOptions nextPageOptions = QueryPageOptions.builder().continuationToken(this.continuationToken).pageSize(pageOptions.getPageSize()).build();
            TwinQueryResponse nextPage = this.queryClient.queryTwins(this.originalQuery, nextPageOptions);
            this.twins = nextPage.twins;
            this.continuationToken = nextPage.continuationToken;
            return this.twins.next();
        }
    }

    void setContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }
}

