/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.registry;

import com.microsoft.azure.sdk.iot.service.auth.AuthenticationMechanism;
import com.microsoft.azure.sdk.iot.service.auth.AuthenticationType;
import com.microsoft.azure.sdk.iot.service.registry.DeviceStatus;
import com.microsoft.azure.sdk.iot.service.registry.ImportMode;
import com.microsoft.azure.sdk.iot.service.registry.serializers.AuthenticationParser;
import com.microsoft.azure.sdk.iot.service.registry.serializers.AuthenticationTypeParser;
import com.microsoft.azure.sdk.iot.service.registry.serializers.ExportImportDeviceParser;
import com.microsoft.azure.sdk.iot.service.registry.serializers.SymmetricKeyParser;
import com.microsoft.azure.sdk.iot.service.registry.serializers.X509ThumbprintParser;
import com.microsoft.azure.sdk.iot.service.twin.TwinCollection;
import java.util.UUID;
import lombok.NonNull;

public class ExportImportDevice {
    @NonNull
    private String id;
    private String eTag;
    private ImportMode importMode;
    private DeviceStatus status;
    private String statusReason;
    private AuthenticationMechanism authentication;
    private TwinCollection tags = null;
    private TwinCollection reportedProperties = null;
    private TwinCollection desiredProperties = null;

    public ExportImportDevice() {
        this.authentication = new AuthenticationMechanism(AuthenticationType.SAS);
        this.id = "exportImportDevice_" + UUID.randomUUID();
    }

    public ExportImportDevice(String deviceId, AuthenticationType authenticationType) throws IllegalArgumentException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("DeviceId cannot be null.");
        }
        if (authenticationType == null) {
            throw new IllegalArgumentException("AuthenticationType cannot be null");
        }
        this.authentication = new AuthenticationMechanism(authenticationType);
        this.id = deviceId;
    }

    public AuthenticationMechanism getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(AuthenticationMechanism authentication) throws IllegalArgumentException {
        if (authentication == null) {
            throw new IllegalArgumentException("The provided authentication object may not be null");
        }
        this.authentication = authentication;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ExportImportDeviceParser toExportImportDeviceParser() {
        ExportImportDeviceParser parser = new ExportImportDeviceParser();
        parser.setETag(this.eTag);
        parser.setId(this.id);
        parser.setStatusReason(this.statusReason);
        if (this.importMode != null) {
            parser.setImportMode(this.importMode.toString());
        }
        if (this.status != null) {
            parser.setStatus(this.status.toString());
        }
        if (this.authentication != null) {
            parser.setAuthentication(new AuthenticationParser());
            if (this.getAuthentication().getAuthenticationType() != null) {
                parser.getAuthentication().setType(AuthenticationTypeParser.valueOf(this.authentication.getAuthenticationType().toString()));
                if (this.getAuthentication().getAuthenticationType() != AuthenticationType.CERTIFICATE_AUTHORITY) {
                    if (this.getAuthentication().getAuthenticationType() == AuthenticationType.SELF_SIGNED) {
                        if (this.authentication.getPrimaryThumbprint() == null || this.authentication.getSecondaryThumbprint() == null) throw new IllegalStateException("ExportImportDevice cannot have self signed authentication without a complete thumbprint.");
                        parser.getAuthentication().setThumbprint(new X509ThumbprintParser(this.authentication.getPrimaryThumbprint(), this.authentication.getSecondaryThumbprint()));
                    } else if (this.getAuthentication().getAuthenticationType() == AuthenticationType.SAS) {
                        if (this.authentication.getSymmetricKey() == null || this.authentication.getSymmetricKey().getPrimaryKey() == null || this.authentication.getSymmetricKey().getSecondaryKey() == null) throw new IllegalStateException("ExportImportDevice cannot have SAS authentication without a complete symmetric key.");
                        parser.getAuthentication().setSymmetricKey(new SymmetricKeyParser(this.authentication.getSymmetricKey().getPrimaryKey(), this.authentication.getSymmetricKey().getSecondaryKey()));
                    }
                }
            }
        }
        parser.setTags(this.tags);
        return parser;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public ImportMode getImportMode() {
        return this.importMode;
    }

    public void setImportMode(ImportMode importMode) {
        this.importMode = importMode;
    }

    public DeviceStatus getStatus() {
        return this.status;
    }

    public void setStatus(DeviceStatus status) {
        this.status = status;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public TwinCollection getTags() {
        return this.tags;
    }

    public void setTags(TwinCollection tags) {
        this.tags = tags;
    }

    public TwinCollection getReportedProperties() {
        return this.reportedProperties;
    }

    public void setReportedProperties(TwinCollection reportedProperties) {
        this.reportedProperties = reportedProperties;
    }

    public TwinCollection getDesiredProperties() {
        return this.desiredProperties;
    }

    public void setDesiredProperties(TwinCollection desiredProperties) {
        this.desiredProperties = desiredProperties;
    }
}

