/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.registry;

import com.microsoft.azure.sdk.iot.service.registry.serializers.RegistryStatisticsParser;

public class RegistryStatistics {
    private final long totalDeviceCount;
    private final long enabledDeviceCount;
    private final long disabledDeviceCount;

    RegistryStatistics(RegistryStatisticsParser registryStatisticsParser) {
        if (registryStatisticsParser == null) {
            throw new IllegalArgumentException("The registryStatisticsParser may not be null");
        }
        this.totalDeviceCount = registryStatisticsParser.getTotalDeviceCount();
        this.enabledDeviceCount = registryStatisticsParser.getEnabledDeviceCount();
        this.disabledDeviceCount = registryStatisticsParser.getDisabledDeviceCount();
    }

    RegistryStatisticsParser toRegistryStatisticsParser() {
        RegistryStatisticsParser parser = new RegistryStatisticsParser();
        parser.setTotalDeviceCount(this.totalDeviceCount);
        parser.setEnabledDeviceCount(this.enabledDeviceCount);
        parser.setDisabledDeviceCount(this.disabledDeviceCount);
        return parser;
    }

    public long getTotalDeviceCount() {
        return this.totalDeviceCount;
    }

    public long getEnabledDeviceCount() {
        return this.enabledDeviceCount;
    }

    public long getDisabledDeviceCount() {
        return this.disabledDeviceCount;
    }
}

