/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportUtils {
    private static final Logger log = LoggerFactory.getLogger(TransportUtils.class);
    public static final String versionIdentifierKey = "com.microsoft:client-version";
    public static final String javaServiceClientIdentifier = "com.microsoft.azure.sdk.iot.iot-service-client/";
    public static final String serviceVersion = TransportUtils.getPackageVersion();
    private static final String JAVA_RUNTIME = System.getProperty("java.version");
    private static final String OPERATING_SYSTEM = System.getProperty("java.runtime.name").toLowerCase().contains("android") ? "Android" : System.getProperty("os.name");
    private static final String PROCESSOR_ARCHITECTURE = System.getProperty("os.arch");
    public static final String USER_AGENT_STRING = "com.microsoft.azure.sdk.iot.iot-service-client/" + serviceVersion + " (" + JAVA_RUNTIME + "; " + OPERATING_SYSTEM + "; " + PROCESSOR_ARCHITECTURE + ")";
    public static final String IOTHUB_API_VERSION = "2021-04-12";

    private static String getPackageVersion() {
        Map<String, String> properties = TransportUtils.getProperties("iothub-service-client.properties");
        return properties.getOrDefault("version", "UnknownVersion");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> getProperties(String propertiesFileName) {
        try (InputStream inputStream = TransportUtils.class.getClassLoader().getResourceAsStream(propertiesFileName);){
            if (inputStream == null) return Collections.emptyMap();
            Properties properties = new Properties();
            properties.load(inputStream);
            Map<String, String> map = Collections.unmodifiableMap(properties.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue())));
            return map;
        }
        catch (IOException ex) {
            log.warn("Failed to get properties from " + propertiesFileName, (Throwable)ex);
        }
        return Collections.emptyMap();
    }
}

